#!/usr/bin/octave
function z = cubic(a)
  aaa = a/3.0;
  P = aaa(2) - aaa(1)^2
  Q = (-a(3) + 3.0*aaa(2)*aaa(1) - 2.0*aaa(1)^3) / 2.0
  p = -3.0*P
  q = 2.0*Q
  P3 = P^3
  Q2 = Q^2
  www = 0.0;
  w1  = 0.0;
  if (Q < 0.0)
    www = Q - sqrt(Q^2 + P^3)
    w1  = -(-www)^(1.0/3.0);
  else
    www = Q + sqrt(Q^2 + P^3)
    w1  = www^(1.0/3.0);
  endif;
  fourhour = (-1.0 + i*sqrt(3.0)) / 2.0;
  w = w1 * [1.0 fourhour fourhour']
  x = w - P ./ w
  z = x - aaa(1);
endfunction;
