#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2025 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Near-Mage
# send your bug reports to vv221@dotslashplay.it
###

script_version=20250623.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='near-mage'
GAME_NAME='Near-Mage'

ARCHIVE_BASE_3_NAME='near_mage_1_1_4_83077.sh'
ARCHIVE_BASE_3_MD5='61888c75eb3253b84081e67cda59830e'
ARCHIVE_BASE_3_SIZE='9249571'
ARCHIVE_BASE_3_VERSION='1.1.4-gog83077'
ARCHIVE_BASE_3_URL='https://www.gog.com/game/nearmage'

ARCHIVE_BASE_1_NAME='near_mage_1_1_0c_82721.sh'
ARCHIVE_BASE_1_MD5='bc67408fced128913aff39f6065eeba7'
ARCHIVE_BASE_1_SIZE='9249077'
ARCHIVE_BASE_1_VERSION='1.1.0c-gog82721'

ARCHIVE_BASE_0_NAME='near_mage_1_0_1_82443.sh'
ARCHIVE_BASE_0_MD5='ccbb2228270b80e9a110419f0819d7f9'
ARCHIVE_BASE_0_SIZE='9370785'
ARCHIVE_BASE_0_VERSION='1.0.1-gog82443'

UNITY3D_NAME='Near-Mage'

CONTENT_PATH_DEFAULT='data/noarch/game'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1
libz.so.1'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Prevent inclusion of shipped Steam library.
	rm --recursive "$(unity3d_name)_Data/Plugins"
)

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
