/* Opcode and core register tables for Infineon's TriCore architecture.
   Copyright (C) 1998-2003 Free Software Foundation, Inc.
   Contributed by Michael Schumacher (mike@hightec-rt.com).

This file is part of GDB, GAS, and the GNU binutils.

GDB, GAS, and the GNU binutils are free software; you can redistribute
them and/or modify them under the terms of the GNU General Public
License as published by the Free Software Foundation; either version
1, or (at your option) any later version.

GDB, GAS, and the GNU binutils are distributed in the hope that they
will be useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this file; see the file COPYING.  If not, write to the Free
Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1335 USA.
*/

#include "../../../include/ansidecl.h"
#include "../../../include/opcode/tricore.h"
/* The TriCore has a number of special function registers, which are
   described below.  Their actual address is some implementation
   specific base address, plus their 16-bit offset.  */

const struct tricore_core_register tricore_sfrs[] =
{
  { "$mmucon",	0x8000, TRICORE_RIDER_D_UP},
  { "$mmu_con",	0x8000, TRICORE_RIDER_D_UP},
  { "$asi",	0x8004, TRICORE_RIDER_D_UP},
  { "$mmu_asi",	0x8004, TRICORE_RIDER_D_UP},
  { "$mmuid",	0x8008, TRICORE_RIDER_D_UP},
  { "$mmu_id",	0x8008, TRICORE_RIDER_D_UP},
  { "$tva",	0x800c, TRICORE_RIDER_D_UP},
  { "$mmu_tva",	0x800c, TRICORE_RIDER_D_UP},
  { "$tpa",	0x8010, TRICORE_RIDER_D_UP},
  { "$mmu_tpa",	0x8010, TRICORE_RIDER_D_UP},
  { "$tpx",	0x8014, TRICORE_RIDER_D_UP},
  { "$mmu_tpx",	0x8014, TRICORE_RIDER_D_UP},
  { "$tfa",	0x8018, TRICORE_RIDER_D_UP},
  { "$mmu_tfa",	0x8018, TRICORE_RIDER_D_UP},
  { "$mmu_lpma",	0x801c, TRICORE_V2_UP},
  { "$mmu_tfas",	0x8020, TRICORE_V2_UP},

  { "$dspr",	0x9000, TRICORE_V2_UP},
  { "$dcache",	0x9008, TRICORE_V2_UP},
  { "$memtr",	0x9010, TRICORE_V2_UP},
  { "$datr",	0x9018, TRICORE_V2_UP},
  { "$dttar",	0x901c, TRICORE_V2_UP},

  { "$pspr",	0x9200, TRICORE_V2_UP},
  { "$pcache",	0x9208, TRICORE_V2_UP},
  { "$pcon",	0x920c, TRICORE_V2_UP},
  { "$pstr",	0x9214, TRICORE_V2_UP},

  { "$dpr0_0l",	0xc000, TRICORE_GENERIC},
  { "$dpr0_0u",	0xc004, TRICORE_GENERIC},
  { "$dpr0_1l",	0xc008, TRICORE_GENERIC},
  { "$dpr0_1u",	0xc00c, TRICORE_GENERIC},
  { "$dpr0_2l",	0xc010, TRICORE_GENERIC},
  { "$dpr0_2u",	0xc014, TRICORE_GENERIC},
  { "$dpr0_3l",	0xc018, TRICORE_GENERIC},
  { "$dpr0_3u",	0xc01c, TRICORE_GENERIC},

  { "$dpr1_0l",	0xc400, TRICORE_GENERIC},
  { "$dpr1_0u",	0xc404, TRICORE_GENERIC},
  { "$dpr1_1l",	0xc408, TRICORE_GENERIC},
  { "$dpr1_1u",	0xc40c, TRICORE_GENERIC},
  { "$dpr1_2l",	0xc410, TRICORE_GENERIC},
  { "$dpr1_2u",	0xc414, TRICORE_GENERIC},
  { "$dpr1_3l",	0xc418, TRICORE_GENERIC},
  { "$dpr1_3u",	0xc41c, TRICORE_GENERIC},

  { "$dpr2_0l",	0xc800, TRICORE_RIDER_B_UP},
  { "$dpr2_0u",	0xc804, TRICORE_RIDER_B_UP},
  { "$dpr2_1l",	0xc808, TRICORE_RIDER_B_UP},
  { "$dpr2_1u",	0xc80c, TRICORE_RIDER_B_UP},
  { "$dpr2_2l",	0xc810, TRICORE_RIDER_B_UP},
  { "$dpr2_2u",	0xc814, TRICORE_RIDER_B_UP},
  { "$dpr2_3l",	0xc818, TRICORE_RIDER_B_UP},
  { "$dpr2_3u",	0xc81c, TRICORE_RIDER_B_UP},

  { "$dpr3_0l",	0xcc00, TRICORE_RIDER_B_UP},
  { "$dpr3_0u",	0xcc04, TRICORE_RIDER_B_UP},
  { "$dpr3_1l",	0xcc08, TRICORE_RIDER_B_UP},
  { "$dpr3_1u",	0xcc0c, TRICORE_RIDER_B_UP},
  { "$dpr3_2l",	0xcc10, TRICORE_RIDER_B_UP},
  { "$dpr3_2u",	0xcc14, TRICORE_RIDER_B_UP},
  { "$dpr3_3l",	0xcc18, TRICORE_RIDER_B_UP},
  { "$dpr3_3u",	0xcc1c, TRICORE_RIDER_B_UP},

  { "$cpr0_0l",	0xd000, TRICORE_GENERIC},
  { "$cpr0_0u",	0xd004, TRICORE_GENERIC},
  { "$cpr0_1l",	0xd008, TRICORE_GENERIC},
  { "$cpr0_1u",	0xd00c, TRICORE_GENERIC},
  { "$cpr0_2l",	0xd010, TRICORE_RIDER_B_UP},
  { "$cpr0_2u",	0xd014, TRICORE_RIDER_B_UP},
  { "$cpr0_3l",	0xd018, TRICORE_RIDER_B_UP},
  { "$cpr0_3u",	0xd01c, TRICORE_RIDER_B_UP},

  { "$cpr1_0l",	0xd400, TRICORE_GENERIC},
  { "$cpr1_0u",	0xd404, TRICORE_GENERIC},
  { "$cpr1_1l",	0xd408, TRICORE_GENERIC},
  { "$cpr1_1u",	0xd40c, TRICORE_GENERIC},
  { "$cpr1_2l",	0xd410, TRICORE_RIDER_B_UP},
  { "$cpr1_2u",	0xd414, TRICORE_RIDER_B_UP},
  { "$cpr1_3l",	0xd418, TRICORE_RIDER_B_UP},
  { "$cpr1_3u",	0xd41c, TRICORE_RIDER_B_UP},

  { "$cpr2_0l",	0xd800, TRICORE_RIDER_B_UP},
  { "$cpr2_0u",	0xd804, TRICORE_RIDER_B_UP},
  { "$cpr2_1l",	0xd808, TRICORE_RIDER_B_UP},
  { "$cpr2_1u",	0xd80c, TRICORE_RIDER_B_UP},
  { "$cpr2_2l",	0xd810, TRICORE_RIDER_B_UP},
  { "$cpr2_2u",	0xd814, TRICORE_RIDER_B_UP},
  { "$cpr2_3l",	0xd818, TRICORE_RIDER_B_UP},
  { "$cpr2_3u",	0xd81c, TRICORE_RIDER_B_UP},

  { "$cpr3_0l",	0xdc00, TRICORE_RIDER_B_UP},
  { "$cpr3_0u",	0xdc04, TRICORE_RIDER_B_UP},
  { "$cpr3_1l",	0xdc08, TRICORE_RIDER_B_UP},
  { "$cpr3_1u",	0xdc0c, TRICORE_RIDER_B_UP},
  { "$cpr3_2l",	0xdc10, TRICORE_RIDER_B_UP},
  { "$cpr3_2u",	0xdc14, TRICORE_RIDER_B_UP},
  { "$cpr3_3l",	0xdc18, TRICORE_RIDER_B_UP},
  { "$cpr3_3u",	0xdc1c, TRICORE_RIDER_B_UP},

  { "$dpm0_0",	0xe000, TRICORE_GENERIC},
  { "$dpm0_1",	0xe001, TRICORE_GENERIC},
  { "$dpm0_2",	0xe002, TRICORE_GENERIC},
  { "$dpm0_3",	0xe003, TRICORE_GENERIC},

  { "$dpm1_0",	0xe080, TRICORE_GENERIC},
  { "$dpm1_1",	0xe081, TRICORE_GENERIC},
  { "$dpm1_2",	0xe082, TRICORE_GENERIC},
  { "$dpm1_3",	0xe083, TRICORE_GENERIC},

  { "$cpm0_0",	0xe200, TRICORE_GENERIC},
  { "$cpm0_1",	0xe201, TRICORE_GENERIC},

  { "$cpm1_0",	0xe280, TRICORE_GENERIC},
  { "$cpm1_1",	0xe281, TRICORE_GENERIC},

  { "$dbgsr",	0xfd00, TRICORE_GENERIC},
  { "$gprwb",	0xfd04, TRICORE_GENERIC},
  { "$exevt",	0xfd08, TRICORE_GENERIC},
  { "$crevt",	0xfd0c, TRICORE_GENERIC},
  { "$swevt",	0xfd10, TRICORE_GENERIC},
  { "$tr0evt",	0xfd20, TRICORE_GENERIC},
  { "$tr1evt",	0xfd24, TRICORE_GENERIC},

  { "$pcxi",	0xfe00, TRICORE_GENERIC},
  { "$psw",	0xfe04, TRICORE_GENERIC},
  { "$pc",	0xfe08, TRICORE_GENERIC},
  { "$dbiten",	0xfe0c, TRICORE_RIDER_A},
  { "$syscon",	0xfe14, TRICORE_GENERIC},
  { "$cpuid",	0xfe18, TRICORE_RIDER_B_UP},
  { "$cpu_id",	0xfe18, TRICORE_RIDER_B_UP},
  { "$biv",	0xfe20, TRICORE_GENERIC},
  { "$btv",	0xfe24, TRICORE_GENERIC},
  { "$isp",	0xfe28, TRICORE_GENERIC},
  { "$icr",	0xfe2c, TRICORE_GENERIC},
  { "$fcx",	0xfe38, TRICORE_GENERIC},
  { "$lcx",	0xfe3c, TRICORE_GENERIC},

  { "$d0",	0xff00, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},
  { "$d1",	0xff04, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},
  { "$d2",	0xff08, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},
  { "$d3",	0xff0c, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},
  { "$d4",	0xff10, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},
  { "$d5",	0xff14, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},
  { "$d6",	0xff18, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},
  { "$d7",	0xff1c, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},
  { "$d8",	0xff20, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},
  { "$d9",	0xff24, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},
  { "$d10",	0xff28, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},
  { "$d11",	0xff2c, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},
  { "$d12",	0xff30, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},
  { "$d13",	0xff34, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},
  { "$d14",	0xff38, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},
  { "$d15",	0xff3c, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},

  { "$a0",	0xff80, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},
  { "$a1",	0xff84, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},
  { "$a2",	0xff88, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},
  { "$a3",	0xff8c, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},
  { "$a4",	0xff90, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},
  { "$a5",	0xff94, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},
  { "$a6",	0xff98, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},
  { "$a7",	0xff9c, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},
  { "$a8",	0xffa0, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},
  { "$a9",	0xffa4, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},
  { "$a10",	0xffa8, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},
  { "$a11",	0xffac, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},
  { "$a12",	0xffb0, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},
  { "$a13",	0xffb4, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},
  { "$a14",	0xffb8, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},
  { "$a15",	0xffbc, TRICORE_RIDER_A | TRICORE_RIDER_D_DN},

  /* These are not core SFRs, but they can be accessed using the
     18-bit absolute address mode.  */

  { "$pwrclc",	0xf0000000, TRICORE_GENERIC},
  { "$pwrid",	0xf0000008, TRICORE_GENERIC},
  { "$rstreq",	0xf0000010, TRICORE_GENERIC},
  { "$rstsr",	0xf0000014, TRICORE_GENERIC},
  { "$wdtcon0",	0xf0000020, TRICORE_GENERIC},
  { "$wdtcon1",	0xf0000024, TRICORE_GENERIC},
  { "$wdtsr",	0xf0000028, TRICORE_GENERIC},
  { "$nmisr",	0xf000002c, TRICORE_GENERIC},
  { "$pmcon",	0xf0000030, TRICORE_GENERIC},
  { "$pmcsr",	0xf0000034, TRICORE_GENERIC},
  { "$pllclc",	0xf0000040, TRICORE_GENERIC},
  { "$eckclc",	0xf0000044, TRICORE_GENERIC},
  { "$icuclc",	0xf0000048, TRICORE_GENERIC},

  { "$stmclc",	0xf0000300, TRICORE_GENERIC},
  { "$stmid",	0xf0000308, TRICORE_GENERIC},
  { "$systim0",	0xf0000320, TRICORE_GENERIC},
  { "$systim1",	0xf0000324, TRICORE_GENERIC},
  { "$systim2",	0xf0000328, TRICORE_GENERIC},
  { "$systim3",	0xf000032c, TRICORE_GENERIC},
  { "$systim4",	0xf0000330, TRICORE_GENERIC},
  { "$systim5",	0xf0000334, TRICORE_GENERIC},
  { "$systim6",	0xf0000338, TRICORE_GENERIC},
  { "$systim7",	0xf000033c, TRICORE_GENERIC},

  { "$jdpid",	0xf0000408, TRICORE_GENERIC},
  { "$comdata",	0xf0000468, TRICORE_GENERIC},
  { "$iosr",	0xf000046c, TRICORE_GENERIC},

  { "$ebucon",	0xf0000510, TRICORE_GENERIC},
  { "$drmcon",	0xf0000514, TRICORE_GENERIC},
  { "$drmstat",	0xf0000518, TRICORE_GENERIC},
  { "$addsel0",	0xf0000520, TRICORE_GENERIC},
  { "$addsel1",	0xf0000524, TRICORE_GENERIC},
  { "$addsel2",	0xf0000528, TRICORE_GENERIC},
  { "$addsel3",	0xf000052c, TRICORE_GENERIC},
  { "$addsel4",	0xf0000530, TRICORE_GENERIC},
  { "$addsel5",	0xf0000534, TRICORE_GENERIC},
  { "$addsel6",	0xf0000538, TRICORE_GENERIC},
  { "$addsel7",	0xf000053c, TRICORE_GENERIC},

  { "$buscon0",	0xf0000560, TRICORE_GENERIC},
  { "$buscon1",	0xf0000564, TRICORE_GENERIC},
  { "$buscon2",	0xf0000568, TRICORE_GENERIC},
  { "$buscon3",	0xf000056c, TRICORE_GENERIC},
  { "$buscon4",	0xf0000570, TRICORE_GENERIC},
  { "$buscon5",	0xf0000574, TRICORE_GENERIC},
  { "$buscon6",	0xf0000578, TRICORE_GENERIC},
  { "$buscon7",	0xf000057c, TRICORE_GENERIC},

  { "$gtclc",	0xf0000700, TRICORE_GENERIC},
  { "$gtid",	0xf0000708, TRICORE_GENERIC},
  { "$t01irs",	0xf0000710, TRICORE_GENERIC},
  { "$t01ots",	0xf0000714, TRICORE_GENERIC},
  { "$t2con",	0xf0000718, TRICORE_GENERIC},
  { "$t2rccon",	0xf000071c, TRICORE_GENERIC},
  { "$t2ais",	0xf0000720, TRICORE_GENERIC},
  { "$t2bis",	0xf0000724, TRICORE_GENERIC},
  { "$t2es",	0xf0000728, TRICORE_GENERIC},
  { "$gtosel",	0xf000072c, TRICORE_GENERIC},
  { "$gtout",	0xf0000730, TRICORE_GENERIC},
  { "$t0dcba",	0xf0000734, TRICORE_GENERIC},
  { "$t0cba",	0xf0000738, TRICORE_GENERIC},
  { "$t0rdcba",	0xf000073c, TRICORE_GENERIC},
  { "$t0rcba",	0xf0000740, TRICORE_GENERIC},
  { "$t1dcba",	0xf0000744, TRICORE_GENERIC},
  { "$t1cba",	0xf0000748, TRICORE_GENERIC},
  { "$t1rdcba",	0xf000074c, TRICORE_GENERIC},
  { "$t1rcba",	0xf0000750, TRICORE_GENERIC},
  { "$t2",	0xf0000754, TRICORE_GENERIC},
  { "$t2rc0",	0xf0000758, TRICORE_GENERIC},
  { "$t2rc1",	0xf000075c, TRICORE_GENERIC},
  { "$t012run",	0xf0000760, TRICORE_GENERIC},

  { "$gtsrsel",	0xf00007dc, TRICORE_GENERIC},
  { "$gtsrc0",	0xf00007e0, TRICORE_GENERIC},
  { "$gtsrc1",	0xf00007e4, TRICORE_GENERIC},
  { "$gtsrc2",	0xf00007e8, TRICORE_GENERIC},
  { "$gtsrc3",	0xf00007ec, TRICORE_GENERIC},
  { "$gtsrc4",	0xf00007f0, TRICORE_GENERIC},
  { "$gtsrc5",	0xf00007f4, TRICORE_GENERIC},
  { "$gtsrc6",	0xf00007f8, TRICORE_GENERIC},
  { "$gtsrc7",	0xf00007fc, TRICORE_GENERIC},

  { "$pcpclc",	0xf0003f00, TRICORE_GENERIC},
  { "$pcpid",	0xf0003f08, TRICORE_GENERIC},
  { "$pcpcs",	0xf0003f10, TRICORE_GENERIC},
  { "$pcpes",	0xf0003f14, TRICORE_GENERIC},
  { "$pcpicr",	0xf0003f20, TRICORE_GENERIC},
  { "$pcpsrc3",	0xf0003ff0, TRICORE_GENERIC},
  { "$pcpsrc2",	0xf0003ff4, TRICORE_GENERIC},
  { "$pcpsrc1",	0xf0003ff8, TRICORE_GENERIC},
  { "$pcpsrc0",	0xf0003ffc, TRICORE_GENERIC}
};

const int tricore_numsfrs = sizeof tricore_sfrs / sizeof tricore_sfrs[0];

/* Here are the opcodes for the TriCore CPU.  The assembler requires that
   all instances of the same mnemonic must be consecutive (16-bit versions
   before 32-bit, BOL before BO).  If they aren't, the assembler will bomb
   at runtime.  The disassembler shouldn't care, though.  */

struct tricore_opcode tricore_opcodes[] =
{
#define INDICES 0, 0
  { "abs",        1, 0x01c0000b, 0x0e3f0ff4, F(RR),   2, "dd",    "13",
		 TRICORE_GENERIC, INDICES},
  { "abs.b",      1, 0x05c0000b, 0x0a3f0ff4, F(RR),   2, "dd",    "13",
		 TRICORE_GENERIC, INDICES},
  { "abs.h",      1, 0x07c0000b, 0x083f0ff4, F(RR),   2, "dd",    "13",
		 TRICORE_GENERIC, INDICES},
  { "absdif",     1, 0x00e0000b, 0x0f1f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "absdif",     1, 0x01c0008b, 0x0e200074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "absdif.b",   1, 0x04e0000b, 0x0b1f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "absdif.h",   1, 0x06e0000b, 0x091f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "absdifs",    1, 0x00f0000b, 0x0f0f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "absdifs",    1, 0x01e0008b, 0x0e000074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "absdifs.b",  1, 0x04f0000b, 0x0b0f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_RIDER_A, INDICES},
  { "absdifs.h",  1, 0x06f0000b, 0x090f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "abss",       1, 0x01d0000b, 0x0e2f0ff4, F(RR),   2, "dd",    "13",
		 TRICORE_GENERIC, INDICES},
  { "abss.b",     1, 0x05d0000b, 0x0a2f0ff4, F(RR),   2, "dd",    "13",
		 TRICORE_RIDER_A, INDICES},
  { "abss.h",     1, 0x07d0000b, 0x082f0ff4, F(RR),   2, "dd",    "13",
		 TRICORE_GENERIC, INDICES},
  { "add",        0, 0x00000012, 0xffff00ed, F(SRR),  3, "did",   "201",
		 TRICORE_RIDER_B_UP, INDICES},
  { "add",        0, 0x00000092, 0xffff006d, F(SRC),  3, "di4",   "201",
		 TRICORE_RIDER_B_UP, INDICES},
  { "add",        0, 0x0000001a, 0xffff00e5, F(SRR),  3, "idd",   "021",
		 TRICORE_GENERIC, INDICES},
  { "add",        0, 0x00000042, 0xffff00bd, F(SRR),  2, "dd",    "21",
		 TRICORE_GENERIC, INDICES},
  { "add",        0, 0x0000009a, 0xffff0065, F(SRC),  3, "id4",   "021",
		 TRICORE_GENERIC, INDICES},
  { "add",        0, 0x000000c2, 0xffff003d, F(SRC),  2, "d4",    "21",
		 TRICORE_GENERIC, INDICES},
  { "add",        1, 0x0000000b, 0x0fff00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "add",        1, 0x0000008b, 0x0fe00074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "add.a",      0, 0x00000030, 0xffff00cf, F(SRR),  2, "aa",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "add.a",      0, 0x000000b0, 0xffff004f, F(SRC),  2, "a4",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "add.a",      1, 0x00100001, 0x0fef00fe, F(RR),   3, "aaa",   "143",
		 TRICORE_GENERIC, INDICES},
  { "add.b",      1, 0x0400000b, 0x0bff00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "add.f",      1, 0x0021006b, 0x00def094, F(RRR),  3, "ddd",   "125",
  		 TRICORE_RIDER_D_UP, INDICES},
  { "add.h",      1, 0x0600000b, 0x09ff00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "addc",       1, 0x0050000b, 0x0faf00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "addc",       1, 0x00a0008b, 0x0f400074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "addi",       1, 0x0000001b, 0x000000e4, F(RLC),  3, "ddw",   "132",
		 TRICORE_GENERIC, INDICES},
  { "addih",      1, 0x0000009b, 0x00000064, F(RLC),  3, "ddW",   "132",
		 TRICORE_GENERIC, INDICES},
  { "addih.a",    1, 0x00000011, 0x000000ee, F(RLC),  3, "aaW",   "132",
		 TRICORE_GENERIC, INDICES},
  { "adds",       0, 0x00000022, 0xffff00dd, F(SRR),  2, "dd",    "21",
		 TRICORE_GENERIC, INDICES},
  { "adds",       1, 0x0020000b, 0x0fdf00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "adds",       1, 0x0040008b, 0x0fa00074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "adds.b",     1, 0x0420000b, 0x0bdf00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_RIDER_A, INDICES},
  { "adds.bu",    1, 0x0430000b, 0x0bcf00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_RIDER_A, INDICES},
  { "adds.h",     1, 0x0620000b, 0x09df00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "adds.hu",    1, 0x0630000b, 0x09cf00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "adds.u",     1, 0x0030000b, 0x0fcf00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "adds.u",     1, 0x0060008b, 0x0f800074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "addsc.a",    0, 0x00000010, 0xffff002f, F(SRRS), 3, "ad2",   "213",
		 TRICORE_RIDER_A, INDICES},
  { "addsc.a",    0, 0x00000010, 0xffff002f, F(SRRS), 4, "aai2",  "2103",
		 TRICORE_RIDER_B_UP, INDICES},
  { "addsc.a",    1, 0x06000001, 0x09fc00fe, F(RR),   4, "aad2",  "1432",
		 TRICORE_RIDER_A, INDICES},
  { "addsc.a",    1, 0x06000001, 0x09fc00fe, F(RR),   4, "aad2",  "1342",
		 TRICORE_RIDER_B_UP, INDICES},
  { "addsc.a",    1, 0x06010001, 0x09fc00fe, F(RR),   4, "aad2",  "1342",
		 TRICORE_RIDER_B_UP, INDICES},
  { "addsc.a",    1, 0x06020001, 0x09fc00fe, F(RR),   4, "aad2",  "1342",
		 TRICORE_RIDER_B_UP, INDICES},
  { "addsc.a",    1, 0x06030001, 0x09fc00fe, F(RR),   4, "aad2",  "1342",
		 TRICORE_RIDER_B_UP, INDICES},
  { "addsc.at",   1, 0x06200001, 0x09df00fe, F(RR),   3, "aad",   "143",
		 TRICORE_RIDER_A, INDICES},
  { "addsc.at",   1, 0x06200001, 0x09df00fe, F(RR),   3, "aad",   "134",
		 TRICORE_RIDER_B_UP, INDICES},
  { "addx",       1, 0x0040000b, 0x0fbf00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "addx",       1, 0x0080008b, 0x0f600074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "and",        0, 0x00000016, 0xffff00e9, F(SRR),  2, "dd",    "21",
		 TRICORE_RIDER_A, INDICES},
  { "and",        0, 0x00000026, 0xffff00d9, F(SRR),  2, "dd",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "and",        0, 0x00000096, 0xffff0069, F(SC),   2, "i8",    "01",
		 TRICORE_RIDER_A, INDICES},
  { "and",        0, 0x00000016, 0xffff00e9, F(SC),   2, "i8",    "01",
		 TRICORE_RIDER_B_UP, INDICES},
  { "and",        1, 0x0080000f, 0x0f7f00f0, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "and",        1, 0x0100008f, 0x0ee00070, F(RC),   3, "ddn",   "132",
		 TRICORE_GENERIC, INDICES},
  { "and.and.t",  1, 0x00000047, 0x006000b8, F(BIT),  5, "dd5d5", "15342",
		 TRICORE_GENERIC, INDICES},
  { "and.andn.t", 1, 0x00600047, 0x000000b8, F(BIT),  5, "dd5d5", "15342",
		 TRICORE_GENERIC, INDICES},
  { "and.eq",     1, 0x0200000b, 0x0dff00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "and.eq",     1, 0x0400008b, 0x0be00074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "and.ge",     1, 0x0240000b, 0x0dbf00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "and.ge",     1, 0x0480008b, 0x0b600074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "and.ge.u",   1, 0x0250000b, 0x0daf00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "and.ge.u",   1, 0x04a0008b, 0x0b400074, F(RC),   3, "ddn",   "132",
		 TRICORE_GENERIC, INDICES},
  { "and.lt",     1, 0x0220000b, 0x0ddf00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "and.lt",     1, 0x0440008b, 0x0ba00074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "and.lt.u",   1, 0x0230000b, 0x0dcf00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "and.lt.u",   1, 0x0460008b, 0x0b800074, F(RC),   3, "ddn",   "132",
		 TRICORE_GENERIC, INDICES},
  { "and.ne",     1, 0x0210000b, 0x0def00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "and.ne",     1, 0x0420008b, 0x0bc00074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "and.nor.t",  1, 0x00400047, 0x002000b8, F(BIT),  5, "dd5d5", "15342",
		 TRICORE_GENERIC, INDICES},
  { "and.or.t",   1, 0x00200047, 0x004000b8, F(BIT),  5, "dd5d5", "15342",
		 TRICORE_GENERIC, INDICES},
  { "and.t",      1, 0x00000087, 0x00600078, F(BIT),  5, "dd5d5", "15342",
		 TRICORE_GENERIC, INDICES},
  { "andn",       1, 0x00e0000f, 0x0f1f00f0, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "andn",       1, 0x01c0008f, 0x0e200070, F(RC),   3, "ddn",   "132",
		 TRICORE_GENERIC, INDICES},
  { "andn.t",     1, 0x00600087, 0x00000078, F(BIT),  5, "dd5d5", "15342",
		 TRICORE_GENERIC, INDICES},
  { "bisr",       0, 0x000000c0, 0xffff003f, F(SC),   1, "8",     "1",
		 TRICORE_RIDER_A, INDICES},
  { "bisr",       0, 0x000000e0, 0xffff001f, F(SC),   1, "8",     "1",
		 TRICORE_RIDER_B_UP, INDICES},
  { "bisr",       1, 0x000000ad, 0xffe00f52, F(RC),   1, "n",     "2",
		 TRICORE_GENERIC, INDICES},
  { "bmerge",     1, 0x0000004b, 0x0fff00b4, F(RR),   3, "ddd",   "143",
		 TRICORE_RIDER_A, INDICES},
  { "bmerge",     1, 0x0010004b, 0x0fef00b4, F(RR),   3, "ddd",   "143",
		 TRICORE_RIDER_B_UP, INDICES},
  { "bsplit",     1, 0x0600004b, 0x09fff0b4, F(RR),   2, "Dd",    "14",
		 TRICORE_RIDER_A, INDICES},
  { "bsplit",     1, 0x0090004b, 0x0f6ff0b4, F(RR),   2, "Dd",    "14",
		 TRICORE_RIDER_B_UP, INDICES},
  { "cachea.i",   1, 0x03800089, 0x0c400f76, F(BO),   2, ">0",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "cachea.i",   1, 0x038000a9, 0xfc7f0f56, F(BO),   1, "#",     "2",
		 TRICORE_RIDER_B_UP, INDICES},
  { "cachea.i",   1, 0x07800089, 0x08400f76, F(BO),   2, "<0",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "cachea.i",   1, 0x078000a9, 0x08400f56, F(BO),   2, "*0",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "cachea.i",   1, 0x0b800089, 0x04400f76, F(BO),   2, "@0",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "cachea.i",   1, 0x0b8000a9, 0xf47f0f56, F(BO),   1, "?",     "2",
  		 TRICORE_V2_UP, INDICES},
  { "cachea.w",   1, 0x03000089, 0x0cc00f76, F(BO),   2, ">0",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "cachea.w",   1, 0x030000a9, 0xfcff0f56, F(BO),   1, "#",     "2",
		 TRICORE_RIDER_B_UP, INDICES},
  { "cachea.w",   1, 0x07000089, 0x08c00f76, F(BO),   2, "<0",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "cachea.w",   1, 0x070000a9, 0x08c00f56, F(BO),   2, "*0",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "cachea.w",   1, 0x0b000089, 0x04c00f76, F(BO),   2, "@0",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "cachea.w",   1, 0x0b0000a9, 0xf4ff0f56, F(BO),   1, "?",     "2",
  		 TRICORE_V2_UP, INDICES},
  { "cachea.wi",  1, 0x03400089, 0x0c800f76, F(BO),   2, ">0",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "cachea.wi",  1, 0x034000a9, 0xfcbf0f56, F(BO),   1, "#",     "2",
		 TRICORE_RIDER_B_UP, INDICES},
  { "cachea.wi",  1, 0x07400089, 0x08800f76, F(BO),   2, "<0",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "cachea.wi",  1, 0x074000a9, 0x08800f56, F(BO),   2, "*0",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "cachea.wi",  1, 0x0b400089, 0x04800f76, F(BO),   2, "@0",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "cachea.wi",  1, 0x0b4000a9, 0xf4bf0f56, F(BO),   1, "?",     "2",
  		 TRICORE_V2_UP, INDICES},
  { "cachei.w",   1, 0x02c00089, 0x0d000f76, F(BO),   2, ">0",    "21",
  		 TRICORE_V2_UP, INDICES},
  { "cachei.w",   1, 0x06c00089, 0x09000f76, F(BO),   2, "<0",    "21",
  		 TRICORE_V2_UP, INDICES},
  { "cachei.w",   1, 0x0ac00089, 0x05000f76, F(BO),   2, "@0",    "21",
  		 TRICORE_V2_UP, INDICES},
  { "cachei.wi",  1, 0x03c00089, 0x0c000f76, F(BO),   2, ">0",    "21",
  		 TRICORE_V2_UP, INDICES},
  { "cachei.wi",  1, 0x07c00089, 0x08000f76, F(BO),   2, "<0",    "21",
  		 TRICORE_V2_UP, INDICES},
  { "cachei.wi",  1, 0x0bc00089, 0x04000f76, F(BO),   2, "@0",    "21",
  		 TRICORE_V2_UP, INDICES},
  { "cadd",       0, 0x0000000a, 0xffff00f5, F(SRR),  3, "did",   "201",
		 TRICORE_RIDER_A, INDICES},
  { "cadd",       0, 0x0000008a, 0xffff0075, F(SRC),  3, "di4",   "201",
		 TRICORE_GENERIC, INDICES},
  { "cadd",       1, 0x0000002b, 0x00ff00d4, F(RRR),  4, "dddd",  "1254",
		 TRICORE_GENERIC, INDICES},
  { "cadd",       1, 0x000000ab, 0x00e00054, F(RCR),  4, "ddd9",  "1243",
		 TRICORE_GENERIC, INDICES},
  { "cadd.a",     1, 0x00000021, 0x00ff00de, F(RRR),  4, "adaa",  "1254",
		 TRICORE_RIDER_A, INDICES},
  { "cadd.a",     1, 0x000000a1, 0x00e0005e, F(RCR),  4, "ada9",  "1243",
		 TRICORE_RIDER_A, INDICES},
  { "caddn",      0, 0x0000004a, 0xffff00b5, F(SRR),  3, "did",   "201",
		 TRICORE_RIDER_A, INDICES},
  { "caddn",      0, 0x000000ca, 0xffff0035, F(SRC),  3, "di4",   "201",
		 TRICORE_GENERIC, INDICES},
  { "caddn",      1, 0x0010002b, 0x00ef00d4, F(RRR),  4, "dddd",  "1254",
		 TRICORE_GENERIC, INDICES},
  { "caddn",      1, 0x002000ab, 0x00c00054, F(RCR),  4, "ddd9",  "1243",
		 TRICORE_GENERIC, INDICES},
  { "caddn.a",    1, 0x00100021, 0x00ef00de, F(RRR),  4, "adaa",  "1254",
		 TRICORE_RIDER_A, INDICES},
  { "caddn.a",    1, 0x002000a1, 0x00c0005e, F(RCR),  4, "ada9",  "1243",
		 TRICORE_RIDER_A, INDICES},
  { "call",       0, 0x0000005c, 0xffff00a3, F(SB),   1, "R",     "1",
		 TRICORE_RIDER_B_UP, INDICES},
  { "call",       1, 0x0000006d, 0x00000092, F(B),    1, "O",     "1",
		 TRICORE_GENERIC, INDICES},
  { "calla",      1, 0x000000ed, 0x00000012, F(B),    1, "T",     "1",
		 TRICORE_GENERIC, INDICES},
  { "calli",      1, 0x0000002d, 0xffff0fd2, F(RR),   1, "a",     "3",
		 TRICORE_RIDER_A, INDICES},
  { "calli",      1, 0x0000002d, 0xfffff0d2, F(RR),   1, "a",     "4",
		 TRICORE_RIDER_B_UP, INDICES},
  { "clo",        1, 0x01c0000f, 0x0e3ff0f0, F(RR),   2, "dd",    "14",
		 TRICORE_GENERIC, INDICES},
  { "clo.b",      1, 0x03d0000f, 0x0c2ff0f0, F(RR),   2, "dd",    "14",
		 TRICORE_RIDER_A, INDICES},
  { "clo.h",      1, 0x07d0000f, 0x082ff0f0, F(RR),   2, "dd",    "14",
		 TRICORE_GENERIC, INDICES},
  { "cls",        1, 0x01d0000f, 0x0e2ff0f0, F(RR),   2, "dd",    "14",
		 TRICORE_GENERIC, INDICES},
  { "cls.b",      1, 0x03e0000f, 0x0c1ff0f0, F(RR),   2, "dd",    "14",
		 TRICORE_RIDER_A, INDICES},
  { "cls.h",      1, 0x07e0000f, 0x081ff0f0, F(RR),   2, "dd",    "14",
		 TRICORE_GENERIC, INDICES},
  { "clz",        1, 0x01b0000f, 0x0e4ff0f0, F(RR),   2, "dd",    "14",
		 TRICORE_GENERIC, INDICES},
  { "clz.b",      1, 0x03c0000f, 0x0c3ff0f0, F(RR),   2, "dd",    "14",
		 TRICORE_RIDER_A, INDICES},
  { "clz.h",      1, 0x07c0000f, 0x083ff0f0, F(RR),   2, "dd",    "14",
		 TRICORE_GENERIC, INDICES},
  { "cmov",       0, 0x0000002a, 0xffff00d5, F(SRR),  3, "did",   "201",
		 TRICORE_GENERIC, INDICES},
  { "cmov",       0, 0x000000aa, 0xffff0055, F(SRC),  3, "di4",   "201",
		 TRICORE_GENERIC, INDICES},
  { "cmovn",      0, 0x0000006a, 0xffff0095, F(SRR),  3, "did",   "201",
		 TRICORE_GENERIC, INDICES},
  { "cmovn",      0, 0x000000ea, 0xffff0015, F(SRC),  3, "di4",   "201",
		 TRICORE_GENERIC, INDICES},
  { "cmp.f",      1, 0x0001004b, 0x0ffe00b4, F(RR),   3, "ddd",   "143",
  		 TRICORE_RIDER_D_UP, INDICES},
  { "csub",       1, 0x0020002b, 0x00df00d4, F(RRR),  4, "dddd",  "1254",
		 TRICORE_GENERIC, INDICES},
  { "csub.a",     1, 0x00200021, 0x00df00de, F(RRR),  4, "adaa",  "1254",
		 TRICORE_RIDER_A, INDICES},
  { "csubn",      1, 0x0030002b, 0x00cf00d4, F(RRR),  4, "dddd",  "1254",
		 TRICORE_GENERIC, INDICES},
  { "csubn.a",    1, 0x00300021, 0x00cf00de, F(RRR),  4, "adaa",  "1254",
		 TRICORE_RIDER_A, INDICES},
  { "debug",      0, 0x0000a000, 0xffff5fff, F(SR),   0, "",      "",
		 TRICORE_GENERIC, INDICES},
  { "debug",      1, 0x0100000d, 0xfefffff2, F(SYS),  0, "",      "",
		 TRICORE_GENERIC, INDICES},
  { "dextr",      1, 0x00000077, 0x007f0088, F(RRPW), 4, "ddd5",  "1542",
		 TRICORE_GENERIC, INDICES},
  { "dextr",      1, 0x00800017, 0x007f00e8, F(RRRR), 4, "dddd",  "1432",
		 TRICORE_GENERIC, INDICES},
  { "difsc.a",    1, 0x05000001, 0x0afc00fe, F(RR),   4, "daa2",  "1432",
		 TRICORE_RIDER_A, INDICES},
  { "disable",    1, 0x0340000d, 0xfcbffff2, F(SYS),  0, "",      "",
		 TRICORE_GENERIC, INDICES},
  { "disable",    1, 0x03c0000d, 0xfc3ff0f2, F(SYS),  1, "d",     "1",
  		 TRICORE_V2_UP, INDICES},
  { "div.f",      1, 0x0051004b, 0x0fae00b4, F(RR),   3, "ddd",   "143",
  		 TRICORE_RIDER_D_UP, INDICES},
  { "dsync",      1, 0x0480000d, 0xfb7ffff2, F(SYS),  0, "",      "",
		 TRICORE_GENERIC, INDICES},
  { "dvadj",      0, 0x00000072, 0xffff008d, F(SRR),  2, "Dd",    "21",
		 TRICORE_RIDER_A, INDICES},
  { "dvadj",      1, 0x0080002b, 0x007f0fd4, F(RRR),  3, "DDd",   "124",
		 TRICORE_RIDER_A, INDICES},
  { "dvadj",      1, 0x00d0006b, 0x002f0f94, F(RRR),  3, "DDd",   "124",
		 TRICORE_RIDER_B_UP, INDICES},
  { "dvinit",     1, 0x0000004f, 0x0fff00b0, F(RR),   3, "Ddd",   "143",
		 TRICORE_RIDER_A, INDICES},
  { "dvinit",     1, 0x01a0004b, 0x0e5f00b4, F(RR),   3, "Ddd",   "143",
		 TRICORE_RIDER_B_UP, INDICES},
  { "dvinit.b",   1, 0x0040004f, 0x0fbf00b0, F(RR),   3, "Ddd",   "143",
		 TRICORE_RIDER_A, INDICES},
  { "dvinit.b",   1, 0x05a0004b, 0x0a5f00b4, F(RR),   3, "Ddd",   "143",
		 TRICORE_RIDER_B_UP, INDICES},
  { "dvinit.bu",  1, 0x0050004f, 0x0faf00b0, F(RR),   3, "Ddd",   "143",
		 TRICORE_RIDER_A, INDICES},
  { "dvinit.bu",  1, 0x04a0004b, 0x0b5f00b4, F(RR),   3, "Ddd",   "143",
		 TRICORE_RIDER_B_UP, INDICES},
  { "dvinit.h",   1, 0x0020004f, 0x0fdf00b0, F(RR),   3, "Ddd",   "143",
		 TRICORE_RIDER_A, INDICES},
  { "dvinit.h",   1, 0x03a0004b, 0x0c5f00b4, F(RR),   3, "Ddd",   "143",
		 TRICORE_RIDER_B_UP, INDICES},
  { "dvinit.hu",  1, 0x0030004f, 0x0fcf00b0, F(RR),   3, "Ddd",   "143",
		 TRICORE_RIDER_A, INDICES},
  { "dvinit.hu",  1, 0x02a0004b, 0x0d5f00b4, F(RR),   3, "Ddd",   "143",
		 TRICORE_RIDER_B_UP, INDICES},
  { "dvinit.u",   1, 0x0010004f, 0x0fef00b0, F(RR),   3, "Ddd",   "143",
		 TRICORE_RIDER_A, INDICES},
  { "dvinit.u",   1, 0x00a0004b, 0x0f5f00b4, F(RR),   3, "Ddd",   "143",
		 TRICORE_RIDER_B_UP, INDICES},
  { "dvstep",     0, 0x00000032, 0xffff00cd, F(SRR),  2, "Dd",    "21",
		 TRICORE_RIDER_A, INDICES},
  { "dvstep",     1, 0x0090002b, 0x006f0fd4, F(RRR),  3, "DDd",   "124",
		 TRICORE_RIDER_A, INDICES},
  { "dvstep",     1, 0x00f0006b, 0x000f0f94, F(RRR),  3, "DDd",   "124",
		 TRICORE_RIDER_B_UP, INDICES},
  { "dvstep.u",   0, 0x000000b2, 0xffff004d, F(SRR),  2, "Dd",    "21",
		 TRICORE_RIDER_A, INDICES},
  { "dvstep.u",   1, 0x00a0002b, 0x005f0fd4, F(RRR),  3, "DDd",   "124",
		 TRICORE_RIDER_A, INDICES},
  { "dvstep.u",   1, 0x00e0006b, 0x001f0f94, F(RRR),  3, "DDd",   "124",
		 TRICORE_RIDER_B_UP, INDICES},
  { "enable",     1, 0x0300000d, 0xfcfffff2, F(SYS),  0, "",      "",
		 TRICORE_GENERIC, INDICES},
  { "eq",         0, 0x0000003a, 0xffff00c5, F(SRR),  3, "idd",   "021",
		 TRICORE_GENERIC, INDICES},
  { "eq",         0, 0x000000ba, 0xffff0045, F(SRC),  3, "id4",   "021",
		 TRICORE_GENERIC, INDICES},
  { "eq",         1, 0x0100000b, 0x0eff00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "eq",         1, 0x0200008b, 0x0de00074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "eq.a",       1, 0x04000001, 0x0bff00fe, F(RR),   3, "daa",   "143",
		 TRICORE_GENERIC, INDICES},
  { "eq.b",       1, 0x0500000b, 0x0aff00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "eq.h",       1, 0x0700000b, 0x08ff00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "eq.w",       1, 0x0900000b, 0x06ff00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "eqany.b",    1, 0x0560000b, 0x0a9f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "eqany.b",    1, 0x0ac0008b, 0x05200074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "eqany.h",    1, 0x0760000b, 0x089f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "eqany.h",    1, 0x0ec0008b, 0x01200074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "eqz.a",      1, 0x04800001, 0x0b7ff0fe, F(RR),   2, "da",    "14",
		 TRICORE_GENERIC, INDICES},
  { "extr",       1, 0x00400017, 0x00bff0e8, F(RRRR), 3, "ddD",   "142",
		 TRICORE_GENERIC, INDICES},
  { "extr",       1, 0x00400037, 0x0020f0c8, F(RRPW), 4, "dd55",  "1523",
		 TRICORE_GENERIC, INDICES},
  { "extr",       1, 0x00400057, 0x00a0f0a8, F(RRRW), 4, "ddd5",  "1523",
		 TRICORE_GENERIC, INDICES},
  { "extr.u",     1, 0x00600017, 0x009ff0e8, F(RRRR), 3, "ddD",   "142",
		 TRICORE_GENERIC, INDICES},
  { "extr.u",     1, 0x00600037, 0x0000f0c8, F(RRPW), 4, "dd55",  "1523",
		 TRICORE_GENERIC, INDICES},
  { "extr.u",     1, 0x00600057, 0x0080f0a8, F(RRRW), 4, "ddd5",  "1523",
		 TRICORE_GENERIC, INDICES},
  { "fcall",      1, 0x00000061, 0x0000009e, F(B),    1, "O",     "1",
  		 TRICORE_V2_UP, INDICES},
  { "fcalla",     1, 0x000000e1, 0x0000001e, F(B),    1, "T",     "1",
  		 TRICORE_V2_UP, INDICES},
  { "fcalli",     1, 0x0010002d, 0xffeff0d2, F(RR),   1, "a",     "4",
  		 TRICORE_V2_UP, INDICES},
  { "ftoi",       1, 0x0101004b, 0x0efef0b4, F(RR),   2, "dd",    "14",
  		 TRICORE_RIDER_D_UP, INDICES},
  { "ftoq31",     1, 0x0111004b, 0x0eee00b4, F(RR),   3, "ddd",   "143",
  		 TRICORE_RIDER_D_UP, INDICES},
  { "ftou",       1, 0x0121004b, 0x0edef0b4, F(RR),   2, "dd",    "14",
  		 TRICORE_RIDER_D_UP, INDICES},
  { "ge",         1, 0x0140000b, 0x0ebf00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "ge",         1, 0x0280008b, 0x0d600074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "ge.a",       1, 0x04300001, 0x0bcf00fe, F(RR),   3, "daa",   "143",
		 TRICORE_GENERIC, INDICES},
  { "ge.u",       1, 0x0150000b, 0x0eaf00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "ge.u",       1, 0x02a0008b, 0x0d400074, F(RC),   3, "ddn",   "132",
		 TRICORE_GENERIC, INDICES},
  { "imask",      1, 0x00200037, 0x00400fc8, F(RRPW), 4, "Dd55",  "1423",
		 TRICORE_GENERIC, INDICES},
  { "imask",      1, 0x00200057, 0x00c00fa8, F(RRRW), 4, "Ddd5",  "1423",
		 TRICORE_GENERIC, INDICES},
  { "imask",      1, 0x002000b7, 0x00400f48, F(RCPW), 4, "Df55",  "1423",
		 TRICORE_GENERIC, INDICES},
  { "imask",      1, 0x002000d7, 0x00c00f28, F(RCRW), 4, "Dfd5",  "1423",
		 TRICORE_GENERIC, INDICES},
  { "ins.t",      1, 0x00000067, 0x00600098, F(BIT),  5, "dd5d5", "15342",
		 TRICORE_GENERIC, INDICES},
  { "insert",     1, 0x00000017, 0x00ff00e8, F(RRRR), 4, "dddD",  "1432",
		 TRICORE_GENERIC, INDICES},
  { "insert",     1, 0x00000037, 0x006000c8, F(RRPW), 5, "ddd55", "15423",
		 TRICORE_GENERIC, INDICES},
  { "insert",     1, 0x00000057, 0x00e000a8, F(RRRW), 5, "dddd5", "15423",
		 TRICORE_GENERIC, INDICES},
  { "insert",     1, 0x00000097, 0x00ff0068, F(RCRR), 4, "ddfD",  "1432",
		 TRICORE_GENERIC, INDICES},
  { "insert",     1, 0x000000b7, 0x00600048, F(RCPW), 5, "ddf55", "15423",
		 TRICORE_GENERIC, INDICES},
  { "insert",     1, 0x000000d7, 0x00e00028, F(RCRW), 5, "ddfd5", "15423",
		 TRICORE_GENERIC, INDICES},
  { "insn.t",     1, 0x00200067, 0x00400098, F(BIT),  5, "dd5d5", "15342",
		 TRICORE_GENERIC, INDICES},
  { "isync",      1, 0x04c0000d, 0xfb3ffff2, F(SYS),  0, "",      "",
		 TRICORE_GENERIC, INDICES},
  { "itof",       1, 0x0141004b, 0x0ebef0b4, F(RR),   2, "dd",    "14",
		 TRICORE_RIDER_D_UP, INDICES},
  { "ixmax",      1, 0x00a0006b, 0x005f0f94, F(RRR),  3, "DDd",   "124",
		 TRICORE_RIDER_D_UP, INDICES},
  { "ixmax.u",    1, 0x00b0006b, 0x004f0f94, F(RRR),  3, "DDd",   "124",
		 TRICORE_RIDER_D_UP, INDICES},
  { "ixmin",      1, 0x0080006b, 0x007f0f94, F(RRR),  3, "DDd",   "124",
		 TRICORE_RIDER_D_UP, INDICES},
  { "ixmin.u",    1, 0x0090006b, 0x006f0f94, F(RRR),  3, "DDd",   "124",
		 TRICORE_RIDER_D_UP, INDICES},
  { "j",          0, 0x0000005c, 0xffff00a3, F(SB),   1, "R",     "1",
		 TRICORE_RIDER_A, INDICES},
  { "j",          0, 0x0000003c, 0xffff00c3, F(SB),   1, "R",     "1",
		 TRICORE_RIDER_B_UP, INDICES},
  { "j",          1, 0x0000001d, 0x000000e2, F(B),    1, "O",     "1",
		 TRICORE_GENERIC, INDICES},
  { "ja",         1, 0x0000009d, 0x00000062, F(B),    1, "T",     "1",
		 TRICORE_GENERIC, INDICES},
  { "jeq",        0, 0x0000001e, 0xffff00e1, F(SBR),  3, "idm",   "012",
		 TRICORE_RIDER_A, INDICES},
  { "jeq",        0, 0x0000006e, 0xffff0091, F(SBC),  3, "i4m",   "012",
		 TRICORE_RIDER_A, INDICES},
  { "jeq",        0, 0x000000be, 0xffff0041, F(SBR),  3, "idx",   "012",
  		 TRICORE_V2_UP, INDICES},
  { "jeq",        0, 0x0000009e, 0xffff0061, F(SBC),  3, "i4x",   "012",
  		 TRICORE_V2_UP, INDICES},
  { "jeq",        0, 0x0000003e, 0xffff00c1, F(SBR),  3, "idm",   "012",
		 TRICORE_RIDER_B_UP, INDICES},
  { "jeq",        0, 0x0000001e, 0xffff00e1, F(SBC),  3, "i4m",   "012",
		 TRICORE_RIDER_B_UP, INDICES},
  { "jeq",        1, 0x0000005f, 0x800000a0, F(BRR),  3, "ddo",   "321",
		 TRICORE_GENERIC, INDICES},
  { "jeq",        1, 0x000000df, 0x80000020, F(BRC),  3, "d4o",   "321",
		 TRICORE_GENERIC, INDICES},
  { "jeq.a",      1, 0x0000007d, 0x80000082, F(BRR),  3, "aao",   "321",
		 TRICORE_GENERIC, INDICES},
  { "jge",        1, 0x0000007f, 0x80000080, F(BRR),  3, "ddo",   "321",
		 TRICORE_GENERIC, INDICES},
  { "jge",        1, 0x000000ff, 0x80000000, F(BRC),  3, "d4o",   "321",
		 TRICORE_GENERIC, INDICES},
  { "jge.u",      1, 0x8000007f, 0x00000080, F(BRR),  3, "ddo",   "321",
		 TRICORE_GENERIC, INDICES},
  { "jge.u",      1, 0x800000ff, 0x00000000, F(BRC),  3, "dfo",   "321",
		 TRICORE_GENERIC, INDICES},
  { "jgez",       0, 0x000000fe, 0xffff0001, F(SBR),  2, "dm",    "12",
		 TRICORE_RIDER_A, INDICES},
  { "jgez",       0, 0x000000ce, 0xffff0031, F(SBR),  2, "dm",    "12",
		 TRICORE_RIDER_B_UP, INDICES},
  { "jgtz",       0, 0x0000007e, 0xffff0081, F(SBR),  2, "dm",    "12",
		 TRICORE_RIDER_A, INDICES},
  { "jgtz",       0, 0x0000004e, 0xffff00b1, F(SBR),  2, "dm",    "12",
		 TRICORE_RIDER_D_DN, INDICES},
  { "jgtz",       0, 0x0000004e, 0xffff0031, F(SBR),  2, "dm",    "12",
  		 TRICORE_V2_UP, INDICES},
  { "ji",         0, 0x0000003c, 0xffff0fc3, F(SBR),  1, "a",     "1",
		 TRICORE_RIDER_A, INDICES},
  { "ji",         0, 0x000000dc, 0xfffff023, F(SR),   1, "a",     "1",
		 TRICORE_RIDER_B_UP, INDICES},
  { "ji",         1, 0x0030002d, 0xffcf0fd2, F(RR),   1, "a",     "3",
		 TRICORE_RIDER_A, INDICES},
  { "ji",         1, 0x0030002d, 0xffcff0d2, F(RR),   1, "a",     "4",
		 TRICORE_RIDER_B_UP, INDICES},
  { "jl",         1, 0x0000005d, 0x000000a2, F(B),    1, "O",     "1",
		 TRICORE_GENERIC, INDICES},
  { "jla",        1, 0x000000dd, 0x00000022, F(B),    1, "T",     "1",
		 TRICORE_GENERIC, INDICES},
  { "jlez",       0, 0x000000be, 0xffff0041, F(SBR),  2, "dm",    "12",
		 TRICORE_RIDER_A, INDICES},
  { "jlez",       0, 0x0000008e, 0xffff0071, F(SBR),  2, "dm",    "12",
		 TRICORE_RIDER_B_UP, INDICES},
  { "jli",        1, 0x0020002d, 0xffdf0fd2, F(RR),   1, "a",     "3",
		 TRICORE_RIDER_A, INDICES},
  { "jli",        1, 0x0020002d, 0xffdff0d2, F(RR),   1, "a",     "4",
		 TRICORE_RIDER_B_UP, INDICES},
  { "jlt",        1, 0x0000003f, 0x800000c0, F(BRR),  3, "ddo",   "321",
		 TRICORE_GENERIC, INDICES},
  { "jlt",        1, 0x000000bf, 0x80000040, F(BRC),  3, "d4o",   "321",
		 TRICORE_GENERIC, INDICES},
  { "jlt.u",      1, 0x8000003f, 0x000000c0, F(BRR),  3, "ddo",   "321",
		 TRICORE_GENERIC, INDICES},
  { "jlt.u",      1, 0x800000bf, 0x00000040, F(BRC),  3, "dfo",   "321",
		 TRICORE_GENERIC, INDICES},
  { "jltz",       0, 0x0000003e, 0xffff00c1, F(SBR),  2, "dm",    "12",
		 TRICORE_RIDER_A, INDICES},
  { "jltz",       0, 0x0000000e, 0xffff00f1, F(SBR),  2, "dm",    "12",
		 TRICORE_RIDER_D_DN, INDICES},
  { "jltz",       0, 0x0000000e, 0xffff0071, F(SBR),  2, "dm",    "12",
  		 TRICORE_V2_UP, INDICES},
  { "jne",        0, 0x0000009e, 0xffff0061, F(SBR),  3, "idm",   "012",
		 TRICORE_RIDER_A, INDICES},
  { "jne",        0, 0x000000ee, 0xffff0011, F(SBC),  3, "i4m",   "012",
		 TRICORE_RIDER_A, INDICES},
  { "jne",        0, 0x000000fe, 0xffff0001, F(SBR),  3, "idx",   "012",
  		 TRICORE_V2_UP, INDICES},
  { "jne",        0, 0x000000de, 0xffff0021, F(SBC),  3, "i4x",   "012",
  		 TRICORE_V2_UP, INDICES},
  { "jne",        0, 0x0000007e, 0xffff0081, F(SBR),  3, "idm",   "012",
		 TRICORE_RIDER_B_UP, INDICES},
  { "jne",        0, 0x0000005e, 0xffff00a1, F(SBC),  3, "i4m",   "012",
		 TRICORE_RIDER_B_UP, INDICES},
  { "jne",        1, 0x8000005f, 0x000000a0, F(BRR),  3, "ddo",   "321",
		 TRICORE_GENERIC, INDICES},
  { "jne",        1, 0x800000df, 0x00000020, F(BRC),  3, "d4o",   "321",
		 TRICORE_GENERIC, INDICES},
  { "jne.a",      1, 0x8000007d, 0x00000082, F(BRR),  3, "aao",   "321",
		 TRICORE_GENERIC, INDICES},
  { "jned",       1, 0x8000001f, 0x000000e0, F(BRR),  3, "ddo",   "321",
		 TRICORE_GENERIC, INDICES},
  { "jned",       1, 0x8000009f, 0x00000060, F(BRC),  3, "d4o",   "321",
		 TRICORE_GENERIC, INDICES},
  { "jnei",       1, 0x0000001f, 0x800000e0, F(BRR),  3, "ddo",   "321",
		 TRICORE_GENERIC, INDICES},
  { "jnei",       1, 0x0000009f, 0x80000060, F(BRC),  3, "d4o",   "321",
		 TRICORE_GENERIC, INDICES},
  { "jnz",        0, 0x000000ae, 0xffff0051, F(SB),   2, "iR",    "01",
		 TRICORE_RIDER_A, INDICES},
  { "jnz",        0, 0x000000ee, 0xffff0011, F(SB),   2, "iR",    "01",
		 TRICORE_RIDER_B_UP, INDICES},
  { "jnz",        0, 0x000000de, 0xffff0021, F(SBR),  2, "dm",    "12",
		 TRICORE_RIDER_A, INDICES},
  { "jnz",        0, 0x000000f6, 0xffff0009, F(SBR),  2, "dm",    "12",
		 TRICORE_RIDER_B_UP, INDICES},
  { "jnz.a",      0, 0x0000007c, 0xffff0083, F(SBR),  2, "am",    "12",
  		 TRICORE_RIDER_A | TRICORE_RIDER_D_DN, INDICES},
  { "jnz.a",      0, 0x0000007c, 0xffff0003, F(SBR),  2, "am",    "12",
  		 TRICORE_V2_UP, INDICES},
  { "jnz.a",      1, 0x800000bd, 0x0000f042, F(BRR),  2, "ao",    "31",
		 TRICORE_GENERIC, INDICES},
  { "jnz.t",      0, 0x0000004e, 0xffff0031, F(SBRN), 3, "i5m",   "012",
		 TRICORE_RIDER_A, INDICES},
  { "jnz.t",      0, 0x000000ae, 0xffff0051, F(SBRN), 3, "ifm",   "012",
		 TRICORE_RIDER_B_UP, INDICES},
  { "jnz.t",      1, 0x8000006f, 0x00000010, F(BRN),  3, "d5o",   "321",
		 TRICORE_GENERIC, INDICES},
  { "jz",         0, 0x0000002e, 0xffff00d1, F(SB),   2, "iR",    "01",
		 TRICORE_RIDER_A, INDICES},
  { "jz",         0, 0x0000006e, 0xffff0091, F(SB),   2, "iR",    "01",
		 TRICORE_RIDER_B_UP, INDICES},
  { "jz",         0, 0x0000005e, 0xffff00a1, F(SBR),  2, "dm",    "12",
		 TRICORE_RIDER_A, INDICES},
  { "jz",         0, 0x00000076, 0xffff0089, F(SBR),  2, "dm",    "12",
		 TRICORE_RIDER_D_DN, INDICES},
  { "jz",         0, 0x00000076, 0xffff0009, F(SBR),  2, "dm",    "12",
  		 TRICORE_V2_UP, INDICES},
  { "jz.a",       0, 0x000000bc, 0xffff0043, F(SBR),  2, "am",    "12",
		 TRICORE_GENERIC, INDICES},
  { "jz.a",       1, 0x000000bd, 0x8000f042, F(BRR),  2, "ao",    "31",
		 TRICORE_GENERIC, INDICES},
  { "jz.t",       0, 0x0000000e, 0xffff0071, F(SBRN), 3, "i5m",   "012",
		 TRICORE_RIDER_A, INDICES},
  { "jz.t",       0, 0x0000002e, 0xffff00d1, F(SBRN), 3, "ifm",   "012",
		 TRICORE_RIDER_B_UP, INDICES},
  { "jz.t",       1, 0x0000006f, 0x80000010, F(BRN),  3, "d5o",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.a",       0, 0x000000d8, 0xffff0027, F(SC),   3, "I&k",   "001",
		 TRICORE_RIDER_B_UP, INDICES},
  { "ld.a",       0, 0x0000000c, 0xffff00f3, F(SLRO), 3, "aS6",   "201",
		 TRICORE_RIDER_A, INDICES},
  { "ld.a",       0, 0x000000c8, 0xffff0037, F(SLRO), 3, "aS6",   "201",
		 TRICORE_RIDER_B_UP, INDICES},
  { "ld.a",       0, 0x00000028, 0xffff00d7, F(SRO),  3, "I@6",   "012",
		 TRICORE_RIDER_A, INDICES},
  { "ld.a",       0, 0x000000cc, 0xffff0033, F(SRO),  3, "I@6",   "012",
		 TRICORE_RIDER_B_UP, INDICES},
  { "ld.a",       0, 0x00000064, 0xffff009b, F(SLR),  2, "a>",    "21",
		 TRICORE_RIDER_A, INDICES},
  { "ld.a",       0, 0x000000c4, 0xffff003b, F(SLR),  2, "a>",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "ld.a",       0, 0x000000b8, 0xffff0047, F(SLR),  2, "a@",    "21",
		 TRICORE_RIDER_A, INDICES},
  { "ld.a",       0, 0x000000d4, 0xffff002b, F(SLR),  2, "a@",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "ld.a",       1, 0x00000099, 0x00000066, F(BOL),  3, "a@w",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.a",       1, 0x01800009, 0x0e4000f6, F(BO),   3, "a>0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.a",       1, 0x01800029, 0xfe7f00d6, F(BO),   2, "a#",    "32",
		 TRICORE_GENERIC, INDICES},
  { "ld.a",       1, 0x05800009, 0x0a4000f6, F(BO),   3, "a<0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.a",       1, 0x05800029, 0x0a4000d6, F(BO),   3, "a*0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.a",       1, 0x08000085, 0x0400007a, F(ABS),  2, "at",    "21",
		 TRICORE_GENERIC, INDICES},
  { "ld.a",       1, 0x09800009, 0x064000f6, F(BO),   3, "a@0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.a",       1, 0x09800029, 0xf67f00d6, F(BO),   2, "a?",    "32",
  		 TRICORE_V2_UP, INDICES},
  { "ld.b",       0, 0x00000008, 0xffff00f7, F(SRO),  3, "i@f",   "012",
		 TRICORE_RIDER_A, INDICES},
  { "ld.b",       0, 0x00000034, 0xffff00cb, F(SLRO), 3, "dSf",   "201",
		 TRICORE_RIDER_A, INDICES},
  { "ld.b",       0, 0x00000044, 0xffff00bb, F(SLR),  2, "d>",    "21",
		 TRICORE_RIDER_A, INDICES},
  { "ld.b",       0, 0x00000098, 0xffff0067, F(SLR),  2, "d@",    "21",
		 TRICORE_RIDER_A, INDICES},
  { "ld.b",       1, 0x00000005, 0x0c0000fa, F(ABS),  2, "dt",    "21",
		 TRICORE_GENERIC, INDICES},
  { "ld.b",       1, 0x00000009, 0x0fc000f6, F(BO),   3, "d>0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.b",       1, 0x00000029, 0xffff00d6, F(BO),   2, "d#",    "32",
		 TRICORE_GENERIC, INDICES},
  { "ld.b",       1, 0x04000009, 0x0bc000f6, F(BO),   3, "d<0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.b",       1, 0x04000029, 0x0bc000d6, F(BO),   3, "d*0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.b",       1, 0x08000009, 0x07c000f6, F(BO),   3, "d@0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.b",       1, 0x08000029, 0xf7ff00d6, F(BO),   2, "d?",    "32",
  		 TRICORE_V2_UP, INDICES},
  { "ld.bu",      0, 0x00000058, 0xffff00a7, F(SLR),  2, "d@",    "21",
		 TRICORE_RIDER_A, INDICES},
  { "ld.bu",      0, 0x00000014, 0xffff00eb, F(SLR),  2, "d@",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "ld.bu",      0, 0x00000088, 0xffff0077, F(SRO),  3, "i@f",   "012",
		 TRICORE_RIDER_A, INDICES},
  { "ld.bu",      0, 0x0000000c, 0xffff00f3, F(SRO),  3, "i@f",   "012",
		 TRICORE_RIDER_B_UP, INDICES},
  { "ld.bu",      0, 0x000000b4, 0xffff004b, F(SLRO), 3, "dSf",   "201",
		 TRICORE_RIDER_A, INDICES},
  { "ld.bu",      0, 0x00000008, 0xffff00f7, F(SLRO), 3, "dSf",   "201",
		 TRICORE_RIDER_B_UP, INDICES},
  { "ld.bu",      0, 0x000000c4, 0xffff003b, F(SLR),  2, "d>",    "21",
		 TRICORE_RIDER_A, INDICES},
  { "ld.bu",      0, 0x00000004, 0xffff00fb, F(SLR),  2, "d>",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "ld.bu",      1, 0x00400009, 0x0f8000f6, F(BO),   3, "d>0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.bu",      1, 0x00400029, 0xffbf00d6, F(BO),   2, "d#",    "32",
		 TRICORE_GENERIC, INDICES},
  { "ld.bu",      1, 0x04000005, 0x080000fa, F(ABS),  2, "dt",    "21",
		 TRICORE_GENERIC, INDICES},
  { "ld.bu",      1, 0x04400009, 0x0b8000f6, F(BO),   3, "d<0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.bu",      1, 0x04400029, 0x0b8000d6, F(BO),   3, "d*0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.bu",      1, 0x08400009, 0x078000f6, F(BO),   3, "d@0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.bu",      1, 0x08400029, 0xf7bf00d6, F(BO),   2, "d?",    "32",
  		 TRICORE_V2_UP, INDICES},
  { "ld.d",       1, 0x01400009, 0x0e8000f6, F(BO),   3, "D>0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.d",       1, 0x01400029, 0xfebf00d6, F(BO),   2, "D#",    "32",
		 TRICORE_GENERIC, INDICES},
  { "ld.d",       1, 0x04000085, 0x0800007a, F(ABS),  2, "Dt",    "21",
		 TRICORE_GENERIC, INDICES},
  { "ld.d",       1, 0x05400009, 0x0a8000f6, F(BO),   3, "D<0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.d",       1, 0x05400029, 0x0a8000d6, F(BO),   3, "D*0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.d",       1, 0x09400009, 0x068000f6, F(BO),   3, "D@0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.d",       1, 0x09400029, 0xf6bf00d6, F(BO),   2, "D?",    "32",
  		 TRICORE_V2_UP, INDICES},
  { "ld.da",      1, 0x01c00009, 0x0e0000f6, F(BO),   3, "A>0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.da",      1, 0x01c00029, 0xfe3f00d6, F(BO),   2, "A#",    "32",
		 TRICORE_GENERIC, INDICES},
  { "ld.da",      1, 0x05c00009, 0x0a0000f6, F(BO),   3, "A<0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.da",      1, 0x05c00029, 0x0a0000d6, F(BO),   3, "A*0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.da",      1, 0x09c00009, 0x060000f6, F(BO),   3, "A@0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.da",      1, 0x0c000085, 0x0000007a, F(ABS),  2, "At",    "21",
		 TRICORE_GENERIC, INDICES},
  { "ld.da",      1, 0x09c00029, 0xf63f00d6, F(BO),   2, "A?",    "32",
  		 TRICORE_V2_UP, INDICES},
  { "ld.dd",      1, 0x02400009, 0x0d8000f6, F(BO),   3, "D>0",   "321",
  		 TRICORE_V2_UP, INDICES},
  { "ld.dd",      1, 0x02400029, 0xfdbf00d6, F(BO),   2, "D#",    "32",
  		 TRICORE_V2_UP, INDICES},
  { "ld.dd",      1, 0x06400009, 0x098000f6, F(BO),   3, "D<0",   "321",
  		 TRICORE_V2_UP, INDICES},
  { "ld.dd",      1, 0x06400029, 0x098000d6, F(BO),   3, "D*0",   "321",
  		 TRICORE_V2_UP, INDICES},
  { "ld.dd",      1, 0x0a400009, 0x058000f6, F(BO),   3, "D@0",   "321",
  		 TRICORE_V2_UP, INDICES},
  { "ld.dd",      1, 0x0a400029, 0xf5bf00d6, F(BO),   2, "D?",    "32",
  		 TRICORE_V2_UP, INDICES},
  { "ld.h",       0, 0x00000024, 0xffff00db, F(SLR),  2, "d>",    "21",
		 TRICORE_RIDER_A, INDICES},
  { "ld.h",       0, 0x00000084, 0xffff007b, F(SLR),  2, "d>",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "ld.h",       0, 0x00000048, 0xffff00b7, F(SRO),  3, "i@v",   "012",
		 TRICORE_RIDER_A, INDICES},
  { "ld.h",       0, 0x0000008c, 0xffff0073, F(SRO),  3, "i@v",   "012",
		 TRICORE_RIDER_B_UP, INDICES},
  { "ld.h",       0, 0x00000074, 0xffff008b, F(SLRO), 3, "dSv",   "201",
		 TRICORE_RIDER_A, INDICES},
  { "ld.h",       0, 0x00000088, 0xffff0077, F(SLRO), 3, "dSv",   "201",
		 TRICORE_RIDER_B_UP, INDICES},
  { "ld.h",       0, 0x000000d8, 0xffff0027, F(SLR),  2, "d@",    "21",
		 TRICORE_RIDER_A, INDICES},
  { "ld.h",       0, 0x00000094, 0xffff006b, F(SLR),  2, "d@",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "ld.h",       1, 0x00800009, 0x0f4000f6, F(BO),   3, "d>0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.h",       1, 0x00800029, 0xff7f00d6, F(BO),   2, "d#",    "32",
		 TRICORE_GENERIC, INDICES},
  { "ld.h",       1, 0x04800009, 0x0b4000f6, F(BO),   3, "d<0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.h",       1, 0x04800029, 0x0b4000d6, F(BO),   3, "d*0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.h",       1, 0x08000005, 0x040000fa, F(ABS),  2, "dt",    "21",
		 TRICORE_GENERIC, INDICES},
  { "ld.h",       1, 0x08800009, 0x074000f6, F(BO),   3, "d@0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.h",       1, 0x08800029, 0xf77f00d6, F(BO),   2, "d?",    "32",
  		 TRICORE_V2_UP, INDICES},
  { "ld.hu",      1, 0x00c00009, 0x0f0000f6, F(BO),   3, "d>0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.hu",      1, 0x00c00029, 0xff3f00d6, F(BO),   2, "d#",    "32",
		 TRICORE_GENERIC, INDICES},
  { "ld.hu",      1, 0x04c00009, 0x0b0000f6, F(BO),   3, "d<0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.hu",      1, 0x04c00029, 0x0b0000d6, F(BO),   3, "d*0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.hu",      1, 0x08c00009, 0x070000f6, F(BO),   3, "d@0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.hu",      1, 0x0c000005, 0x000000fa, F(ABS),  2, "dt",    "21",
		 TRICORE_GENERIC, INDICES},
  { "ld.hu",      1, 0x08c00029, 0xf73f00d6, F(BO),   2, "d?",    "32",
  		 TRICORE_V2_UP, INDICES},
  { "ld.q",       1, 0x00000045, 0x0c0000ba, F(ABS),  2, "dt",    "21",
		 TRICORE_GENERIC, INDICES},
  { "ld.q",       1, 0x02000009, 0x0dc000f6, F(BO),   3, "d>0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.q",       1, 0x02000029, 0xfdff00d6, F(BO),   2, "d#",    "32",
		 TRICORE_GENERIC, INDICES},
  { "ld.q",       1, 0x06000009, 0x09c000f6, F(BO),   3, "d<0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.q",       1, 0x06000029, 0x09c000d6, F(BO),   3, "d*0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.q",       1, 0x0a000009, 0x05c000f6, F(BO),   3, "d@0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.q",       1, 0x0a000029, 0xf5ff00d6, F(BO),   2, "d?",    "32",
  		 TRICORE_V2_UP, INDICES},
  { "ld.w",       0, 0x00000058, 0xffff00a7, F(SC),   3, "i&k",   "001",
		 TRICORE_RIDER_B_UP, INDICES},
  { "ld.w",       0, 0x00000038, 0xffff00c7, F(SLR),  2, "d@",    "21",
		 TRICORE_RIDER_A, INDICES},
  { "ld.w",       0, 0x00000054, 0xffff00ab, F(SLR),  2, "d@",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "ld.w",       0, 0x000000a4, 0xffff005b, F(SLR),  2, "d>",    "21",
		 TRICORE_RIDER_A, INDICES},
  { "ld.w",       0, 0x00000044, 0xffff00bb, F(SLR),  2, "d>",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "ld.w",       0, 0x000000c8, 0xffff0037, F(SRO),  3, "i@6",   "012",
		 TRICORE_RIDER_A, INDICES},
  { "ld.w",       0, 0x0000004c, 0xffff00b3, F(SRO),  3, "i@6",   "012",
		 TRICORE_RIDER_B_UP, INDICES},
  { "ld.w",       0, 0x000000f4, 0xffff000b, F(SLRO), 3, "dS6",   "201",
		 TRICORE_RIDER_A, INDICES},
  { "ld.w",       0, 0x00000048, 0xffff00b7, F(SLRO), 3, "dS6",   "201",
		 TRICORE_RIDER_B_UP, INDICES},
  { "ld.w",       1, 0x00000019, 0x000000e6, F(BOL),  3, "d@w",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.w",       1, 0x00000085, 0x0c00007a, F(ABS),  2, "dt",    "21",
		 TRICORE_GENERIC, INDICES},
  { "ld.w",       1, 0x01000009, 0x0ec000f6, F(BO),   3, "d>0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.w",       1, 0x01000029, 0xfeff00d6, F(BO),   2, "d#",    "32",
		 TRICORE_GENERIC, INDICES},
  { "ld.w",       1, 0x05000009, 0x0ac000f6, F(BO),   3, "d<0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.w",       1, 0x05000029, 0x0ac000d6, F(BO),   3, "d*0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.w",       1, 0x09000009, 0x06c000f6, F(BO),   3, "d@0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "ld.w",       1, 0x09000029, 0xf6ff00d6, F(BO),   2, "d?",    "32",
  		 TRICORE_V2_UP, INDICES},
  { "ldlcx",      1, 0x08000015, 0x04000fea, F(ABS),  1, "t",     "1",
		 TRICORE_GENERIC, INDICES},
  { "ldlcx",      1, 0x09000049, 0x06c00fb6, F(BO),   2, "@0",    "21",
		 TRICORE_GENERIC, INDICES},
  { "ldmst",      1, 0x00400049, 0x0f8000b6, F(BO),   3, ">0D",   "213",
		 TRICORE_GENERIC, INDICES},
  { "ldmst",      1, 0x00400069, 0xffbf0096, F(BO),   2, "#D",    "23",
		 TRICORE_GENERIC, INDICES},
  { "ldmst",      1, 0x040000e5, 0x0800001a, F(ABS),  2, "tD",    "12",
		 TRICORE_GENERIC, INDICES},
  { "ldmst",      1, 0x04400049, 0x0b8000b6, F(BO),   3, "<0D",   "213",
		 TRICORE_GENERIC, INDICES},
  { "ldmst",      1, 0x04400069, 0x0b800096, F(BO),   3, "*0D",   "213",
		 TRICORE_GENERIC, INDICES},
  { "ldmst",      1, 0x08400049, 0x078000b6, F(BO),   3, "@0D",   "213",
		 TRICORE_GENERIC, INDICES},
  { "ldmst",      1, 0x08400069, 0xf7bf0096, F(BO),   2, "?D",    "23",
  		 TRICORE_V2_UP, INDICES},
  { "lducx",      1, 0x09400049, 0x06800fb6, F(BO),   2, "@0",    "21",
		 TRICORE_GENERIC, INDICES},
  { "lducx",      1, 0x0c000015, 0x00000fea, F(ABS),  1, "t",     "1",
		 TRICORE_GENERIC, INDICES},
  { "lea",        1, 0x000000c5, 0x0c00003a, F(ABS),  2, "at",    "21",
		 TRICORE_GENERIC, INDICES},
  { "lea",        1, 0x000000d9, 0x00000026, F(BOL),  3, "a@w",   "321",
		 TRICORE_GENERIC, INDICES},
  { "lea",        1, 0x0a000049, 0x05c000b6, F(BO),   3, "a@0",   "321",
		 TRICORE_GENERIC, INDICES},
  { "loop",       0, 0x000000fc, 0xffff0003, F(SBR),  2, "ar",    "12",
		 TRICORE_GENERIC, INDICES},
  { "loop",       1, 0x000000fd, 0x80000f02, F(BRR),  2, "ao",    "21",
		 TRICORE_GENERIC, INDICES},
  { "loopu",      1, 0x800000fd, 0x0000ff02, F(BRR),  1, "o",     "1",
		 TRICORE_RIDER_B_UP, INDICES},
  { "lt",         0, 0x0000007a, 0xffff0085, F(SRR),  3, "idd",   "021",
		 TRICORE_GENERIC, INDICES},
  { "lt",         0, 0x000000fa, 0xffff0005, F(SRC),  3, "id4",   "021",
		 TRICORE_GENERIC, INDICES},
  { "lt",         1, 0x0120000b, 0x0edf00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "lt",         1, 0x0240008b, 0x0da00074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "lt.a",       1, 0x04200001, 0x0bdf00fe, F(RR),   3, "daa",   "143",
		 TRICORE_GENERIC, INDICES},
  { "lt.b",       1, 0x0520000b, 0x0adf00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "lt.bu",      1, 0x0530000b, 0x0acf00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "lt.h",       1, 0x0720000b, 0x08df00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "lt.hu",      1, 0x0730000b, 0x08cf00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "lt.u",       0, 0x00000006, 0xffff00f9, F(SRR),  3, "idd",   "021",
		 TRICORE_RIDER_A, INDICES},
  { "lt.u",       0, 0x00000086, 0xffff0079, F(SRC),  3, "idf",   "021",
		 TRICORE_RIDER_A, INDICES},
  { "lt.u",       1, 0x0130000b, 0x0ecf00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "lt.u",       1, 0x0260008b, 0x0d800074, F(RC),   3, "ddn",   "132",
		 TRICORE_GENERIC, INDICES},
  { "lt.w",       1, 0x0920000b, 0x06df00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "lt.wu",      1, 0x0930000b, 0x06cf00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "madd",       1, 0x000a0003, 0x00f500fc, F(RRR2), 4, "dddd",  "1243",
		 TRICORE_GENERIC, INDICES},
  { "madd",       1, 0x00200013, 0x00c000ec, F(RCR),  4, "ddd9",  "1243",
		 TRICORE_GENERIC, INDICES},
  { "madd",       1, 0x00600013, 0x008000ec, F(RCR),  4, "DDd9",  "1243",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madd",       1, 0x006a0003, 0x009500fc, F(RRR2), 4, "DDdd",  "1243",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madd.f",     1, 0x0061006b, 0x009e0094, F(RRR),  4, "dddd",  "1254",
		 TRICORE_RIDER_D_UP, INDICES},
  { "madd.h",     1, 0x00600083, 0x009c007c, F(RRR1), 5, "DDdd1", "12543",
		 TRICORE_RIDER_A, INDICES},
  { "madd.h",     1, 0x00600083, 0x009c007c, F(RRR1), 5, "DDdL1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madd.h",     1, 0x00640083, 0x0098007c, F(RRR1), 5, "DDdl1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madd.h",     1, 0x00680083, 0x0094007c, F(RRR1), 5, "DDd-1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madd.h",     1, 0x006c0083, 0x0090007c, F(RRR1), 5, "DDd+1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madd.q",     1, 0x00100043, 0x00ec00bc, F(RRR1), 5, "dddd1", "12543",
		 TRICORE_RIDER_A, INDICES},
  { "madd.q",     1, 0x00100043, 0x00ec00bc, F(RRR1), 5, "ddGG1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madd.q",     1, 0x00000043, 0x00fc00bc, F(RRR1), 5, "dddG1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madd.q",     1, 0x00040043, 0x00f800bc, F(RRR1), 5, "dddg1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madd.q",     1, 0x00080043, 0x00f400bc, F(RRR1), 5, "dddd1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madd.q",     1, 0x00140043, 0x00e800bc, F(RRR1), 5, "ddgg1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madd.q",     1, 0x00600043, 0x009c00bc, F(RRR1), 5, "DDdG1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madd.q",     1, 0x00640043, 0x009800bc, F(RRR1), 5, "DDdg1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madd.q",     1, 0x006c0043, 0x009000bc, F(RRR1), 5, "DDdd1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madd.q",     1, 0x00700043, 0x008c00bc, F(RRR1), 5, "DDGG1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madd.q",     1, 0x00740043, 0x008800bc, F(RRR1), 5, "DDgg1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madd.u",     1, 0x00400013, 0x00a000ec, F(RCR),  4, "DDdn",  "1243",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madd.u",     1, 0x00680003, 0x009700fc, F(RRR2), 4, "DDdd",  "1243",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddm",      1, 0x00600013, 0x008000ec, F(RCR),  4, "DDd9",  "1243",
		 TRICORE_RIDER_A, INDICES},
  { "maddm",      1, 0x006a0003, 0x009500fc, F(RRR2), 4, "DDdd",  "1243",
		 TRICORE_RIDER_A, INDICES},
  { "maddm.h",    1, 0x00700083, 0x008f007c, F(RRR1), 4, "DDdd",  "1254",
		 TRICORE_RIDER_A, INDICES},
  { "maddm.h",    1, 0x00700083, 0x008c007c, F(RRR1), 5, "DDdL1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddm.h",    1, 0x00740083, 0x0088007c, F(RRR1), 5, "DDdl1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddm.h",    1, 0x00780083, 0x0084007c, F(RRR1), 5, "DDd-1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddm.h",    1, 0x007c0083, 0x0080007c, F(RRR1), 5, "DDd+1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddm.q",    1, 0x00700043, 0x008f00bc, F(RRR1), 4, "DDdd",  "1254",
		 TRICORE_RIDER_A, INDICES},
  { "maddm.u",    1, 0x00400013, 0x00a000ec, F(RCR),  4, "DDdn",  "1243",
		 TRICORE_RIDER_A, INDICES},
  { "maddm.u",    1, 0x00680003, 0x009700fc, F(RRR2), 4, "DDdd",  "1243",
		 TRICORE_RIDER_A, INDICES},
  { "maddms",     1, 0x00e00013, 0x000000ec, F(RCR),  4, "DDd9",  "1243",
		 TRICORE_RIDER_A, INDICES},
  { "maddms",     1, 0x00ea0003, 0x001500fc, F(RRR2), 4, "DDdd",  "1243",
		 TRICORE_RIDER_A, INDICES},
  { "maddms.h",   1, 0x00f00083, 0x000c007c, F(RRR1), 5, "DDdL1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddms.h",   1, 0x00f40083, 0x0008007c, F(RRR1), 5, "DDdl1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddms.h",   1, 0x00f80083, 0x0004007c, F(RRR1), 5, "DDd-1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddms.h",   1, 0x00fc0083, 0x0000007c, F(RRR1), 5, "DDd+1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddms.u",   1, 0x00c00013, 0x002000ec, F(RCR),  4, "DDdn",  "1243",
		 TRICORE_RIDER_A, INDICES},
  { "maddms.u",   1, 0x00e80003, 0x001700fc, F(RRR2), 4, "DDdd",  "1243",
		 TRICORE_RIDER_A, INDICES},
  { "maddr.h",    1, 0x00780043, 0x008400bc, F(RRR1), 5, "dDdd1", "12543",
		 TRICORE_RIDER_A, INDICES},
  { "maddr.h",    1, 0x00780043, 0x008400bc, F(RRR1), 5, "dDdL1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddr.h",    1, 0x00300083, 0x00cc007c, F(RRR1), 5, "dddL1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddr.h",    1, 0x00340083, 0x00c8007c, F(RRR1), 5, "dddl1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddr.h",    1, 0x00380083, 0x00c4007c, F(RRR1), 5, "ddd-1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddr.h",    1, 0x003c0083, 0x00c0007c, F(RRR1), 5, "ddd+1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddr.q",    1, 0x00180043, 0x00e400bc, F(RRR1), 5, "dddd1", "12543",
		 TRICORE_RIDER_A, INDICES},
  { "maddr.q",    1, 0x00180043, 0x00e400bc, F(RRR1), 5, "ddGG1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddr.q",    1, 0x001c0043, 0x00e000bc, F(RRR1), 5, "ddgg1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddrs.h",   1, 0x00f80043, 0x000400bc, F(RRR1), 5, "dDdd1", "12543",
		 TRICORE_RIDER_A, INDICES},
  { "maddrs.h",   1, 0x00f80043, 0x000400bc, F(RRR1), 5, "dDdL1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddrs.h",   1, 0x00b00083, 0x004c007c, F(RRR1), 5, "dddL1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddrs.h",   1, 0x00b40083, 0x0048007c, F(RRR1), 5, "dddl1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddrs.h",   1, 0x00b80083, 0x0044007c, F(RRR1), 5, "ddd-1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddrs.h",   1, 0x00bc0083, 0x0040007c, F(RRR1), 5, "ddd+1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddrs.q",   1, 0x00980043, 0x006400bc, F(RRR1), 5, "dddd1", "12543",
		 TRICORE_RIDER_A, INDICES},
  { "maddrs.q",   1, 0x00980043, 0x006400bc, F(RRR1), 5, "ddGG1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddrs.q",   1, 0x009c0043, 0x006000bc, F(RRR1), 5, "ddgg1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madds",      1, 0x008a0003, 0x007500fc, F(RRR2), 4, "dddd",  "1243",
		 TRICORE_GENERIC, INDICES},
  { "madds",      1, 0x00a00013, 0x004000ec, F(RCR),  4, "ddd9",  "1243",
		 TRICORE_GENERIC, INDICES},
  { "madds",      1, 0x00e00013, 0x000000ec, F(RCR),  4, "DDd9",  "1243",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madds",      1, 0x00ea0003, 0x001500fc, F(RRR2), 4, "DDdd",  "1243",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madds.h",    1, 0x00e00083, 0x001c007c, F(RRR1), 5, "DDdd1", "12543",
		 TRICORE_RIDER_A, INDICES},
  { "madds.h",    1, 0x00e00083, 0x001c007c, F(RRR1), 5, "DDdL1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madds.h",    1, 0x00e40083, 0x0018007c, F(RRR1), 5, "DDdl1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madds.h",    1, 0x00e80083, 0x0014007c, F(RRR1), 5, "DDd-1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madds.h",    1, 0x00ec0083, 0x0010007c, F(RRR1), 5, "DDd+1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madds.q",    1, 0x00900043, 0x006c00bc, F(RRR1), 5, "dddd1", "12543",
		 TRICORE_RIDER_A, INDICES},
  { "madds.q",    1, 0x00900043, 0x006c00bc, F(RRR1), 5, "ddGG1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madds.q",    1, 0x00800043, 0x007c00bc, F(RRR1), 5, "dddG1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madds.q",    1, 0x00840043, 0x007800bc, F(RRR1), 5, "dddg1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madds.q",    1, 0x00880043, 0x007400bc, F(RRR1), 5, "dddd1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madds.q",    1, 0x00940043, 0x006800bc, F(RRR1), 5, "ddgg1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madds.q",    1, 0x00e00043, 0x001c00bc, F(RRR1), 5, "DDdG1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madds.q",    1, 0x00e40043, 0x001800bc, F(RRR1), 5, "DDdg1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madds.q",    1, 0x00ec0043, 0x001000bc, F(RRR1), 5, "DDdd1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madds.q",    1, 0x00f00043, 0x000c00bc, F(RRR1), 5, "DDGG1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madds.q",    1, 0x00f40043, 0x000800bc, F(RRR1), 5, "DDgg1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madds.u",    1, 0x00800013, 0x006000ec, F(RCR),  4, "dddn",  "1243",
		 TRICORE_GENERIC, INDICES},
  { "madds.u",    1, 0x00880003, 0x007700fc, F(RRR2), 4, "dddd",  "1243",
		 TRICORE_GENERIC, INDICES},
  { "madds.u",    1, 0x00c00013, 0x002000ec, F(RCR),  4, "DDdn",  "1243",
		 TRICORE_RIDER_B_UP, INDICES},
  { "madds.u",    1, 0x00e80003, 0x001700fc, F(RRR2), 4, "DDdd",  "1243",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddsu.h",   1, 0x006000c3, 0x009c003c, F(RRR1), 5, "DDdL1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddsu.h",   1, 0x006400c3, 0x0098003c, F(RRR1), 5, "DDdl1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddsu.h",   1, 0x006800c3, 0x0094003c, F(RRR1), 5, "DDd-1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddsu.h",   1, 0x006c00c3, 0x0090003c, F(RRR1), 5, "DDd+1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddsum.h",  1, 0x007000c3, 0x008c003c, F(RRR1), 5, "DDdL1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddsum.h",  1, 0x007400c3, 0x0088003c, F(RRR1), 5, "DDdl1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddsum.h",  1, 0x007800c3, 0x0084003c, F(RRR1), 5, "DDd-1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddsum.h",  1, 0x007c00c3, 0x0080003c, F(RRR1), 5, "DDd+1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddsums.h", 1, 0x00f000c3, 0x000c003c, F(RRR1), 5, "DDdL1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddsums.h", 1, 0x00f400c3, 0x0008003c, F(RRR1), 5, "DDdl1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddsums.h", 1, 0x00f800c3, 0x0004003c, F(RRR1), 5, "DDd-1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddsums.h", 1, 0x00fc00c3, 0x0000003c, F(RRR1), 5, "DDd+1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddsur.h",  1, 0x003000c3, 0x00cc003c, F(RRR1), 5, "dddL1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddsur.h",  1, 0x003400c3, 0x00c8003c, F(RRR1), 5, "dddl1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddsur.h",  1, 0x003800c3, 0x00c4003c, F(RRR1), 5, "ddd-1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddsur.h",  1, 0x003c00c3, 0x00c0003c, F(RRR1), 5, "ddd+1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddsurs.h", 1, 0x00b000c3, 0x004c003c, F(RRR1), 5, "dddL1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddsurs.h", 1, 0x00b400c3, 0x0048003c, F(RRR1), 5, "dddl1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddsurs.h", 1, 0x00b800c3, 0x0044003c, F(RRR1), 5, "ddd-1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddsurs.h", 1, 0x00bc00c3, 0x0040003c, F(RRR1), 5, "ddd+1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddsus.h",  1, 0x00e000c3, 0x001c003c, F(RRR1), 5, "DDdL1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddsus.h",  1, 0x00e400c3, 0x0018003c, F(RRR1), 5, "DDdl1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddsus.h",  1, 0x00e800c3, 0x0014003c, F(RRR1), 5, "DDd-1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "maddsus.h",  1, 0x00ec00c3, 0x0010003c, F(RRR1), 5, "DDd+1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "max",        1, 0x01a0000b, 0x0e5f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "max",        1, 0x0340008b, 0x0ca00074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "max.b",      1, 0x05a0000b, 0x0a5f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "max.bu",     1, 0x05b0000b, 0x0a4f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "max.h",      1, 0x07a0000b, 0x085f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "max.hu",     1, 0x07b0000b, 0x084f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "max.u",      1, 0x01b0000b, 0x0e4f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "max.u",      1, 0x0360008b, 0x0c800074, F(RC),   3, "ddn",   "132",
		 TRICORE_GENERIC, INDICES},
  { "mfcr",       1, 0x0000004d, 0x00000fb2, F(RLC),  2, "dW",    "12",
		 TRICORE_GENERIC, INDICES},
  { "mffr",       1, 0x01d1004b, 0x0e2ef0b4, F(RR),   2, "dd",    "14",
  		 TRICORE_V2_UP, INDICES},
  { "min",        1, 0x0180000b, 0x0e7f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "min",        1, 0x0300008b, 0x0ce00074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "min.b",      1, 0x0580000b, 0x0a7f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "min.bu",     1, 0x0590000b, 0x0a6f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "min.h",      1, 0x0780000b, 0x087f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "min.hu",     1, 0x0790000b, 0x086f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "min.u",      1, 0x0190000b, 0x0e6f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "min.u",      1, 0x0320008b, 0x0cc00074, F(RC),   3, "ddn",   "132",
		 TRICORE_GENERIC, INDICES},
  { "mov",        0, 0x00000002, 0xffff00fd, F(SRR),  2, "dd",    "21",
		 TRICORE_GENERIC, INDICES},
  { "mov",        0, 0x00000082, 0xffff007d, F(SRC),  2, "d4",    "21",
		 TRICORE_GENERIC, INDICES},
  { "mov",        0, 0x000000d2, 0xffff002d, F(SRC),  2, "D4",    "21",
  		 TRICORE_V2_UP, INDICES},
  { "mov",        0, 0x000000c6, 0xffff0039, F(SC),   2, "i8",    "01",
		 TRICORE_RIDER_A, INDICES},
  { "mov",        0, 0x000000da, 0xffff0025, F(SC),   2, "i8",    "01",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mov",        1, 0x0000003b, 0x00000fc4, F(RLC),  2, "dw",    "12",
		 TRICORE_GENERIC, INDICES},
  { "mov",        1, 0x01f0000b, 0x0e0f0ff4, F(RR),   2, "dd",    "13",
		 TRICORE_GENERIC, INDICES},
  { "mov",        1, 0x000000fb, 0x00000f04, F(RLC),  2, "Dw",    "12",
  		 TRICORE_V2_UP, INDICES},
  { "mov",        1, 0x0800000b, 0x07ff0ff4, F(RR),   2, "Dd",    "13",
  		 TRICORE_V2_UP, INDICES},
  { "mov",        1, 0x0810000b, 0x07ef00f4, F(RR),   3, "Ddd",   "143",
  		 TRICORE_V2_UP, INDICES},
  { "mov.a",      0, 0x000000a0, 0xffff005f, F(SRC),  2, "af",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mov.a",      0, 0x00000030, 0xffff00cf, F(SRR),  2, "ad",    "21",
		 TRICORE_RIDER_A, INDICES},
  { "mov.a",      0, 0x00000060, 0xffff009f, F(SRR),  2, "ad",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mov.a",      1, 0x06300001, 0x09cf0ffe, F(RR),   2, "ad",    "13",
		 TRICORE_GENERIC, INDICES},
  { "mov.aa",     0, 0x00000080, 0xffff007f, F(SRR),  2, "aa",    "21",
		 TRICORE_RIDER_A, INDICES},
  { "mov.aa",     0, 0x00000040, 0xffff00bf, F(SRR),  2, "aa",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mov.aa",     1, 0x00000001, 0x0fff0ffe, F(RR),   2, "aa",    "13",
		 TRICORE_GENERIC, INDICES},
  { "mov.d",      0, 0x00000020, 0xffff00df, F(SRR),  2, "da",    "21",
		 TRICORE_RIDER_A, INDICES},
  { "mov.d",      0, 0x00000080, 0xffff007f, F(SRR),  2, "da",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mov.d",      1, 0x04c00001, 0x0b3f0ffe, F(RR),   2, "da",    "13",
		 TRICORE_GENERIC, INDICES},
  { "mov.u",      1, 0x000000bb, 0x00000f44, F(RLC),  2, "dW",    "12",
		 TRICORE_GENERIC, INDICES},
  { "movh",       1, 0x0000007b, 0x00000f84, F(RLC),  2, "dW",    "12",
		 TRICORE_GENERIC, INDICES},
  { "movh.a",     1, 0x00000091, 0x00000f6e, F(RLC),  2, "aW",    "12",
		 TRICORE_GENERIC, INDICES},
  { "movz.a",     0, 0x00001000, 0xffffe0ff, F(SR),   1, "a",     "1",
		 TRICORE_RIDER_A, INDICES},
  { "msub",       1, 0x000a0023, 0x00f500dc, F(RRR2), 4, "dddd",  "1243",
		 TRICORE_GENERIC, INDICES},
  { "msub",       1, 0x00200033, 0x00c000cc, F(RCR),  4, "ddd9",  "1243",
		 TRICORE_GENERIC, INDICES},
  { "msub",       1, 0x00600033, 0x008000cc, F(RCR),  4, "DDd9",  "1243",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msub",       1, 0x006a0023, 0x009500dc, F(RRR2), 4, "DDdd",  "1243",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msub.f",     1, 0x0071006b, 0x008e0094, F(RRR),  4, "dddd",  "1254",
		 TRICORE_RIDER_D_UP, INDICES},
  { "msub.h",     1, 0x006000a3, 0x009c005c, F(RRR1), 5, "DDdd1", "12543",
		 TRICORE_RIDER_A, INDICES},
  { "msub.h",     1, 0x006000a3, 0x009c005c, F(RRR1), 5, "DDdL1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msub.h",     1, 0x006400a3, 0x0098005c, F(RRR1), 5, "DDdl1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msub.h",     1, 0x006800a3, 0x0094005c, F(RRR1), 5, "DDd-1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msub.h",     1, 0x006c00a3, 0x0090005c, F(RRR1), 5, "DDd+1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msub.q",     1, 0x00100063, 0x00ec009c, F(RRR1), 5, "dddd1", "12543",
		 TRICORE_RIDER_A, INDICES},
  { "msub.q",     1, 0x00100063, 0x00ec009c, F(RRR1), 5, "ddGG1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msub.q",     1, 0x00000063, 0x00fc009c, F(RRR1), 5, "dddG1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msub.q",     1, 0x00040063, 0x00f8009c, F(RRR1), 5, "dddg1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msub.q",     1, 0x00080063, 0x00f4009c, F(RRR1), 5, "dddd1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msub.q",     1, 0x00140063, 0x00e8009c, F(RRR1), 5, "ddgg1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msub.q",     1, 0x00600063, 0x009c009c, F(RRR1), 5, "DDdG1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msub.q",     1, 0x00640063, 0x0098009c, F(RRR1), 5, "DDdg1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msub.q",     1, 0x006c0063, 0x0090009c, F(RRR1), 5, "DDdd1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msub.q",     1, 0x00700063, 0x008c009c, F(RRR1), 5, "DDGG1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msub.q",     1, 0x00740063, 0x0088009c, F(RRR1), 5, "DDgg1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msub.u",     1, 0x00400033, 0x00a000cc, F(RCR),  4, "DDdn",  "1243",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msub.u",     1, 0x00680023, 0x009700dc, F(RRR2), 4, "DDdd",  "1243",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubad.h",   1, 0x006000e3, 0x009c001c, F(RRR1), 5, "DDdL1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubad.h",   1, 0x006400e3, 0x0098001c, F(RRR1), 5, "DDdl1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubad.h",   1, 0x006800e3, 0x0094001c, F(RRR1), 5, "DDd-1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubad.h",   1, 0x006c00e3, 0x0090001c, F(RRR1), 5, "DDd+1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubadm.h",  1, 0x007000e3, 0x008c001c, F(RRR1), 5, "DDdL1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubadm.h",  1, 0x007400e3, 0x0088001c, F(RRR1), 5, "DDdl1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubadm.h",  1, 0x007800e3, 0x0084001c, F(RRR1), 5, "DDd-1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubadm.h",  1, 0x007c00e3, 0x0080001c, F(RRR1), 5, "DDd+1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubadms.h", 1, 0x00f000e3, 0x000c001c, F(RRR1), 5, "DDdL1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubadms.h", 1, 0x00f400e3, 0x0008001c, F(RRR1), 5, "DDdl1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubadms.h", 1, 0x00f800e3, 0x0004001c, F(RRR1), 5, "DDd-1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubadms.h", 1, 0x00fc00e3, 0x0000001c, F(RRR1), 5, "DDd+1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubadr.h",  1, 0x003000e3, 0x00cc001c, F(RRR1), 5, "dddL1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubadr.h",  1, 0x003400e3, 0x00c8001c, F(RRR1), 5, "dddl1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubadr.h",  1, 0x003800e3, 0x00c4001c, F(RRR1), 5, "ddd-1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubadr.h",  1, 0x003c00e3, 0x00c0001c, F(RRR1), 5, "ddd+1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubadrs.h", 1, 0x00b000e3, 0x004c001c, F(RRR1), 5, "dddL1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubadrs.h", 1, 0x00b400e3, 0x0048001c, F(RRR1), 5, "dddl1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubadrs.h", 1, 0x00b800e3, 0x0044001c, F(RRR1), 5, "ddd-1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubadrs.h", 1, 0x00bc00e3, 0x0040001c, F(RRR1), 5, "ddd+1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubads.h",  1, 0x00e000e3, 0x001c001c, F(RRR1), 5, "DDdL1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubads.h",  1, 0x00e400e3, 0x0018001c, F(RRR1), 5, "DDdl1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubads.h",  1, 0x00e800e3, 0x0014001c, F(RRR1), 5, "DDd-1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubads.h",  1, 0x00ec00e3, 0x0010001c, F(RRR1), 5, "DDd+1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubm",      1, 0x00600033, 0x008000cc, F(RCR),  4, "DDd9",  "1243",
		 TRICORE_RIDER_A, INDICES},
  { "msubm",      1, 0x006a0023, 0x009500dc, F(RRR2), 4, "DDdd",  "1243",
		 TRICORE_RIDER_A, INDICES},
  { "msubm.h",    1, 0x007000a3, 0x008f005c, F(RRR1), 4, "DDdd",  "1254",
		 TRICORE_RIDER_A, INDICES},
  { "msubm.h",    1, 0x007000a3, 0x008c005c, F(RRR1), 5, "DDdL1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubm.h",    1, 0x007400a3, 0x0088005c, F(RRR1), 5, "DDdl1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubm.h",    1, 0x007800a3, 0x0084005c, F(RRR1), 5, "DDd-1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubm.h",    1, 0x007c00a3, 0x0080005c, F(RRR1), 5, "DDd+1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubm.q",    1, 0x00700063, 0x008f009c, F(RRR1), 4, "DDdd",  "1254",
		 TRICORE_RIDER_A, INDICES},
  { "msubm.u",    1, 0x00400033, 0x00a000cc, F(RCR),  4, "DDdn",  "1243",
		 TRICORE_RIDER_A, INDICES},
  { "msubm.u",    1, 0x00680023, 0x009700dc, F(RRR2), 4, "DDdd",  "1243",
		 TRICORE_RIDER_A, INDICES},
  { "msubms",     1, 0x00e00033, 0x000000cc, F(RCR),  4, "DDd9",  "1243",
		 TRICORE_RIDER_A, INDICES},
  { "msubms",     1, 0x00ea0023, 0x001500dc, F(RRR2), 4, "DDdd",  "1243",
		 TRICORE_RIDER_A, INDICES},
  { "msubms.h",   1, 0x00f000a3, 0x000c005c, F(RRR1), 5, "DDdL1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubms.h",   1, 0x00f400a3, 0x0008005c, F(RRR1), 5, "DDdl1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubms.h",   1, 0x00f800a3, 0x0004005c, F(RRR1), 5, "DDd-1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubms.h",   1, 0x00fc00a3, 0x0000005c, F(RRR1), 5, "DDd+1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubms.u",   1, 0x00c00033, 0x002000cc, F(RCR),  4, "DDdn",  "1243",
		 TRICORE_RIDER_A, INDICES},
  { "msubms.u",   1, 0x00e80023, 0x001700dc, F(RRR2), 4, "DDdd",  "1243",
		 TRICORE_RIDER_A, INDICES},
  { "msubr.h",    1, 0x00780063, 0x0084009c, F(RRR1), 5, "dDdd1", "12543",
		 TRICORE_RIDER_A, INDICES},
  { "msubr.h",    1, 0x00780063, 0x0084009c, F(RRR1), 5, "dDdL1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubr.h",    1, 0x003000a3, 0x00cc005c, F(RRR1), 5, "dddL1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubr.h",    1, 0x003400a3, 0x00c8005c, F(RRR1), 5, "dddl1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubr.h",    1, 0x003800a3, 0x00c4005c, F(RRR1), 5, "ddd-1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubr.h",    1, 0x003c00a3, 0x00c0005c, F(RRR1), 5, "ddd+1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubr.q",    1, 0x00180063, 0x00e4009c, F(RRR1), 5, "dddd1", "12543",
		 TRICORE_RIDER_A, INDICES},
  { "msubr.q",    1, 0x00180063, 0x00e4009c, F(RRR1), 5, "ddGG1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubr.q",    1, 0x001c0063, 0x00e0009c, F(RRR1), 5, "ddgg1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubrs.h",   1, 0x00f80063, 0x0004009c, F(RRR1), 5, "dDdd1", "12543",
		 TRICORE_RIDER_A, INDICES},
  { "msubrs.h",   1, 0x00f80063, 0x0004009c, F(RRR1), 5, "dDdL1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubrs.h",   1, 0x00b000a3, 0x004c005c, F(RRR1), 5, "dddL1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubrs.h",   1, 0x00b400a3, 0x0048005c, F(RRR1), 5, "dddl1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubrs.h",   1, 0x00b800a3, 0x0044005c, F(RRR1), 5, "ddd-1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubrs.h",   1, 0x00bc00a3, 0x0040005c, F(RRR1), 5, "ddd+1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubrs.q",   1, 0x00980063, 0x0064009c, F(RRR1), 5, "dddd1", "12543",
		 TRICORE_RIDER_A, INDICES},
  { "msubrs.q",   1, 0x00980063, 0x0064009c, F(RRR1), 5, "ddGG1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubrs.q",   1, 0x009c0063, 0x0060009c, F(RRR1), 5, "ddgg1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubs",      1, 0x008a0023, 0x007500dc, F(RRR2), 4, "dddd",  "1243",
		 TRICORE_GENERIC, INDICES},
  { "msubs",      1, 0x00a00033, 0x004000cc, F(RCR),  4, "ddd9",  "1243",
		 TRICORE_GENERIC, INDICES},
  { "msubs",      1, 0x00e00033, 0x000000cc, F(RCR),  4, "DDd9",  "1243",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubs",      1, 0x00ea0023, 0x001500dc, F(RRR2), 4, "DDdd",  "1243",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubs.h",    1, 0x00e000a3, 0x001c005c, F(RRR1), 5, "DDdd1", "12543",
		 TRICORE_RIDER_A, INDICES},
  { "msubs.h",    1, 0x00e000a3, 0x001c005c, F(RRR1), 5, "DDdL1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubs.h",    1, 0x00e400a3, 0x0018005c, F(RRR1), 5, "DDdl1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubs.h",    1, 0x00e800a3, 0x0014005c, F(RRR1), 5, "DDd-1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubs.h",    1, 0x00ec00a3, 0x0010005c, F(RRR1), 5, "DDd+1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubs.q",    1, 0x00900063, 0x006c009c, F(RRR1), 5, "dddd1", "12543",
		 TRICORE_RIDER_A, INDICES},
  { "msubs.q",    1, 0x00900063, 0x006c009c, F(RRR1), 5, "ddGG1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubs.q",    1, 0x00800063, 0x007c009c, F(RRR1), 5, "dddG1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubs.q",    1, 0x00840063, 0x0078009c, F(RRR1), 5, "dddg1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubs.q",    1, 0x00880063, 0x0074009c, F(RRR1), 5, "dddd1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubs.q",    1, 0x00940063, 0x0068009c, F(RRR1), 5, "ddgg1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubs.q",    1, 0x00e00063, 0x001c009c, F(RRR1), 5, "DDdG1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubs.q",    1, 0x00e40063, 0x0018009c, F(RRR1), 5, "DDdg1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubs.q",    1, 0x00ec0063, 0x0010009c, F(RRR1), 5, "DDdd1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubs.q",    1, 0x00f00063, 0x000c009c, F(RRR1), 5, "DDGG1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubs.q",    1, 0x00f40063, 0x0008009c, F(RRR1), 5, "DDgg1", "12543",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubs.u",    1, 0x00800033, 0x006000cc, F(RCR),  4, "dddn",  "1243",
		 TRICORE_GENERIC, INDICES},
  { "msubs.u",    1, 0x00880023, 0x007700dc, F(RRR2), 4, "dddd",  "1243",
		 TRICORE_GENERIC, INDICES},
  { "msubs.u",    1, 0x00c00033, 0x002000cc, F(RCR),  4, "DDdn",  "1243",
		 TRICORE_RIDER_B_UP, INDICES},
  { "msubs.u",    1, 0x00e80023, 0x001700dc, F(RRR2), 4, "DDdd",  "1243",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mtcr",       1, 0x000000cd, 0xf0000032, F(RLC),  2, "Wd",    "23",
		 TRICORE_GENERIC, INDICES},
  { "mtfr",       1, 0x01c1004b, 0xfe3e00b4, F(RR),   2, "dd",    "43",
  		 TRICORE_V2_UP, INDICES},
  { "mul",        0, 0x000000e2, 0xffff001d, F(SRR),  2, "dd",    "21",
		 TRICORE_GENERIC, INDICES},
  { "mul",        1, 0x00200053, 0x0fc000ac, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "mul",        1, 0x00a00073, 0x0f5f008c, F(RR),   3, "ddd",   "143",
		 TRICORE_RIDER_A, INDICES},
  { "mul",        1, 0x000a0073, 0x0ff5008c, F(RR2),  3, "ddd",   "132",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mul",        1, 0x00600053, 0x0f8000ac, F(RC),   3, "Dd9",   "132",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mul",        1, 0x006a0073, 0x0f95008c, F(RR2),  3, "Ddd",   "132",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mul.f",      1, 0x0041004b, 0x0fbe00b4, F(RR),   3, "ddd",   "143",
		 TRICORE_RIDER_D_UP, INDICES},
  { "mul.h",      1, 0x018000b3, 0x0e7c004c, F(RR),   4, "Ddd1",  "1432",
		 TRICORE_RIDER_A, INDICES},
  { "mul.h",      1, 0x006000b3, 0x0f9c004c, F(RR1),  4, "DdL1",  "1432",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mul.h",      1, 0x006400b3, 0x0f98004c, F(RR1),  4, "Ddl1",  "1432",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mul.h",      1, 0x006800b3, 0x0f94004c, F(RR1),  4, "Dd-1",  "1432",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mul.h",      1, 0x006c00b3, 0x0f90004c, F(RR1),  4, "Dd+1",  "1432",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mul.q",      1, 0x00400093, 0x0fbc006c, F(RR),   4, "ddd1",  "1432",
		 TRICORE_RIDER_A, INDICES},
  { "mul.q",      1, 0x00000093, 0x0ffc006c, F(RR1),  4, "ddG1",  "1432",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mul.q",      1, 0x00040093, 0x0ff8006c, F(RR1),  4, "ddg1",  "1432",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mul.q",      1, 0x00080093, 0x0ff4006c, F(RR1),  4, "ddd1",  "1432",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mul.q",      1, 0x00100093, 0x0fec006c, F(RR1),  4, "dGG1",  "1432",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mul.q",      1, 0x00140093, 0x0fe8006c, F(RR1),  4, "dgg1",  "1432",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mul.q",      1, 0x00600093, 0x0f9c006c, F(RR1),  4, "DdG1",  "1432",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mul.q",      1, 0x00640093, 0x0f98006c, F(RR1),  4, "Ddg1",  "1432",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mul.q",      1, 0x006c0093, 0x0f90006c, F(RR1),  4, "Ddd1",  "1432",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mul.u",      1, 0x00400053, 0x0fa000ac, F(RC),   3, "Ddn",   "132",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mul.u",      1, 0x00680073, 0x0f97008c, F(RR2),  3, "Ddd",   "132",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mulm",       1, 0x00600053, 0x0f8000ac, F(RC),   3, "Dd9",   "132",
		 TRICORE_RIDER_A, INDICES},
  { "mulm",       1, 0x06a00073, 0x095f008c, F(RR),   3, "Ddd",   "143",
		 TRICORE_RIDER_A, INDICES},
  { "mulm.h",     1, 0x007000b3, 0x0f8c004c, F(RR1),  4, "DdL1",  "1432",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mulm.h",     1, 0x007400b3, 0x0f88004c, F(RR1),  4, "Ddl1",  "1432",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mulm.h",     1, 0x007800b3, 0x0f84004c, F(RR1),  4, "Dd-1",  "1432",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mulm.h",     1, 0x007c00b3, 0x0f80004c, F(RR1),  4, "Dd+1",  "1432",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mulm.u",     1, 0x00400053, 0x0fa000ac, F(RC),   3, "Ddn",   "132",
		 TRICORE_RIDER_A, INDICES},
  { "mulm.u",     1, 0x06800073, 0x097f008c, F(RR),   3, "Ddd",   "143",
		 TRICORE_RIDER_A, INDICES},
  { "mulms.h",    1, 0x00f000b3, 0x0f0c004c, F(RR1),  4, "DdL1",  "1432",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mulms.h",    1, 0x00f400b3, 0x0f08004c, F(RR1),  4, "Ddl1",  "1432",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mulms.h",    1, 0x00f800b3, 0x0f04004c, F(RR1),  4, "Dd-1",  "1432",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mulms.h",    1, 0x00fc00b3, 0x0f00004c, F(RR1),  4, "Dd+1",  "1432",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mulr.h",     1, 0x00c000b3, 0x0f3c004c, F(RR),   4, "ddd1",  "1432",
		 TRICORE_RIDER_A, INDICES},
  { "mulr.h",     1, 0x003000b3, 0x0fcc004c, F(RR1),  4, "ddL1",  "1432",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mulr.h",     1, 0x003400b3, 0x0fc8004c, F(RR1),  4, "ddl1",  "1432",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mulr.h",     1, 0x003800b3, 0x0fc4004c, F(RR1),  4, "dd-1",  "1432",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mulr.h",     1, 0x003c00b3, 0x0fc0004c, F(RR1),  4, "dd+1",  "1432",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mulr.q",     1, 0x00600093, 0x0f9c006c, F(RR),   4, "ddd1",  "1432",
		 TRICORE_RIDER_A, INDICES},
  { "mulr.q",     1, 0x00180093, 0x0fe4006c, F(RR1),  4, "dGG1",  "1432",
		 TRICORE_RIDER_B_UP, INDICES},
  { "mulr.q",     1, 0x001c0093, 0x0fe0006c, F(RR1),  4, "dgg1",  "1432",
		 TRICORE_RIDER_B_UP, INDICES},
  { "muls",       1, 0x00a00053, 0x0f4000ac, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "muls",       1, 0x08a00073, 0x075f008c, F(RR),   3, "ddd",   "143",
		 TRICORE_RIDER_A, INDICES},
  { "muls",       1, 0x008a0073, 0x0f75008c, F(RR2),  3, "ddd",   "132",
		 TRICORE_RIDER_B_UP, INDICES},
  { "muls.u",     1, 0x00800053, 0x0f6000ac, F(RC),   3, "ddn",   "132",
		 TRICORE_GENERIC, INDICES},
  { "muls.u",     1, 0x08800073, 0x077f008c, F(RR),   3, "ddd",   "143",
		 TRICORE_RIDER_A, INDICES},
  { "muls.u",     1, 0x00880073, 0x0f77008c, F(RR2),  3, "ddd",   "132",
		 TRICORE_RIDER_B_UP, INDICES},
  { "nand",       1, 0x0090000f, 0x0f6f00f0, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "nand",       1, 0x0120008f, 0x0ec00070, F(RC),   3, "ddn",   "132",
		 TRICORE_GENERIC, INDICES},
  { "nand.t",     1, 0x00000007, 0x006000f8, F(BIT),  5, "dd5d5", "15342",
		 TRICORE_GENERIC, INDICES},
  { "ne",         1, 0x0110000b, 0x0eef00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "ne",         1, 0x0220008b, 0x0dc00074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "ne.a",       1, 0x04100001, 0x0bef00fe, F(RR),   3, "daa",   "143",
		 TRICORE_GENERIC, INDICES},
  { "nez.a",      1, 0x04900001, 0x0b6ff0fe, F(RR),   2, "da",    "14",
		 TRICORE_GENERIC, INDICES},
  { "nop",        0, 0x00000000, 0xffffffff, F(SR),   0, "",      "",
		 TRICORE_GENERIC, INDICES},
  { "nop",        1, 0x0000000d, 0xfffffff2, F(SYS),  0, "",      "",
		 TRICORE_GENERIC, INDICES},
  { "nor",        0, 0x00000036, 0xfffff0c9, F(SR),   1, "d",     "1",
		 TRICORE_RIDER_A, INDICES},
  { "nor",        0, 0x00000046, 0xfffff0b9, F(SR),   1, "d",     "1",
		 TRICORE_RIDER_B_UP, INDICES},
  { "nor",        1, 0x00b0000f, 0x0f4f00f0, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "nor",        1, 0x0160008f, 0x0e800070, F(RC),   3, "ddn",   "132",
		 TRICORE_GENERIC, INDICES},
  { "nor.t",      1, 0x00400087, 0x00200078, F(BIT),  5, "dd5d5", "15342",
		 TRICORE_GENERIC, INDICES},
  { "or",         0, 0x00000056, 0xffff00a9, F(SRR),  2, "dd",    "21",
		 TRICORE_RIDER_A, INDICES},
  { "or",         0, 0x000000a6, 0xffff0059, F(SRR),  2, "dd",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "or",         0, 0x000000d6, 0xffff0029, F(SC),   2, "i8",    "01",
		 TRICORE_RIDER_A, INDICES},
  { "or",         0, 0x00000096, 0xffff0069, F(SC),   2, "i8",    "01",
		 TRICORE_RIDER_B_UP, INDICES},
  { "or",         1, 0x00a0000f, 0x0f5f00f0, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "or",         1, 0x0140008f, 0x0ea00070, F(RC),   3, "ddn",   "132",
		 TRICORE_GENERIC, INDICES},
  { "or.and.t",   1, 0x000000c7, 0x00600038, F(BIT),  5, "dd5d5", "15342",
		 TRICORE_GENERIC, INDICES},
  { "or.andn.t",  1, 0x006000c7, 0x00000038, F(BIT),  5, "dd5d5", "15342",
		 TRICORE_GENERIC, INDICES},
  { "or.eq",      1, 0x0270000b, 0x0d8f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "or.eq",      1, 0x04e0008b, 0x0b000074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "or.ge",      1, 0x02b0000b, 0x0d4f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "or.ge",      1, 0x0560008b, 0x0a800074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "or.ge.u",    1, 0x02c0000b, 0x0d3f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "or.ge.u",    1, 0x0580008b, 0x0a600074, F(RC),   3, "ddn",   "132",
		 TRICORE_GENERIC, INDICES},
  { "or.lt",      1, 0x0290000b, 0x0d6f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "or.lt",      1, 0x0520008b, 0x0ac00074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "or.lt.u",    1, 0x02a0000b, 0x0d5f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "or.lt.u",    1, 0x0540008b, 0x0aa00074, F(RC),   3, "ddn",   "132",
		 TRICORE_GENERIC, INDICES},
  { "or.ne",      1, 0x0280000b, 0x0d7f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "or.ne",      1, 0x0500008b, 0x0ae00074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "or.nor.t",   1, 0x004000c7, 0x00200038, F(BIT),  5, "dd5d5", "15342",
		 TRICORE_GENERIC, INDICES},
  { "or.or.t",    1, 0x002000c7, 0x00400038, F(BIT),  5, "dd5d5", "15342",
		 TRICORE_GENERIC, INDICES},
  { "or.t",       1, 0x00200087, 0x00400078, F(BIT),  5, "dd5d5", "15342",
		 TRICORE_GENERIC, INDICES},
  { "orn",        1, 0x00f0000f, 0x0f0f00f0, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "orn",        1, 0x01e0008f, 0x0e000070, F(RC),   3, "ddn",   "132",
		 TRICORE_GENERIC, INDICES},
  { "orn.t",      1, 0x00200007, 0x004000f8, F(BIT),  5, "dd5d5", "15342",
		 TRICORE_GENERIC, INDICES},
  { "pack",       1, 0x0000006b, 0x00fff094, F(RRR),  3, "dDd",   "125",
		 TRICORE_GENERIC, INDICES},
  { "parity",     1, 0x0080004b, 0x0f7ff0b4, F(RR),   2, "dd",    "14",
		 TRICORE_RIDER_A, INDICES},
  { "parity",     1, 0x0020004b, 0x0fdff0b4, F(RR),   2, "dd",    "14",
		 TRICORE_RIDER_B_UP, INDICES},
  { "q31tof",     1, 0x0151004b, 0x0eae00b4, F(RR),   3, "ddd",   "143",
		 TRICORE_RIDER_D_UP, INDICES},
  { "qseed.f",    1, 0x0191004b, 0x0e6ef0b4, F(RR),   2, "dd",    "14",
		 TRICORE_RIDER_D_UP, INDICES},
  { "restore",    1, 0x0380000d, 0xfc7ff0f2, F(SYS),  1, "d",     "1",
  		 TRICORE_V2_UP, INDICES},
  { "ret",        0, 0x00009000, 0xffff6fff, F(SR),   0, "",      "",
		 TRICORE_GENERIC, INDICES},
  { "ret",        1, 0x0140000d, 0xfebffff2, F(SYS),  0, "",      "",
		 TRICORE_RIDER_A, INDICES},
  { "ret",        1, 0x0180000d, 0xfe7ffff2, F(SYS),  0, "",      "",
		 TRICORE_RIDER_B_UP, INDICES},
  { "rfe",        0, 0x00008000, 0xffff7fff, F(SR),   0, "",      "",
		 TRICORE_GENERIC, INDICES},
  { "rfe",        1, 0x0180000d, 0xfe7ffff2, F(SYS),  0, "",      "",
		 TRICORE_RIDER_A, INDICES},
  { "rfe",        1, 0x01c0000d, 0xfe3ffff2, F(SYS),  0, "",      "",
		 TRICORE_RIDER_B_UP, INDICES},
  { "rfm",        1, 0x0140000d, 0xfebffff2, F(SYS),  0, "",      "",
		 TRICORE_RIDER_B_UP, INDICES},
  { "rslcx",      1, 0x0240000d, 0xfdbffff2, F(SYS),  0, "",      "",
		 TRICORE_GENERIC, INDICES},
  { "rstv",       1, 0x0000002f, 0xffffffd0, F(SYS),  0, "",      "",
		 TRICORE_GENERIC, INDICES},
  { "rsub",       0, 0x000050d2, 0xffffa02d, F(SR),   1, "d",     "1",
		 TRICORE_RIDER_A, INDICES},
  { "rsub",       0, 0x00005032, 0xffffa0cd, F(SR),   1, "d",     "1",
		 TRICORE_RIDER_B_UP, INDICES},
  { "rsub",       1, 0x0100008b, 0x0ee00074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "rsubs",      1, 0x0140008b, 0x0ea00074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "rsubs.u",    1, 0x0160008b, 0x0e800074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "sat.b",      0, 0x000000d2, 0xfffff02d, F(SR),   1, "d",     "1",
		 TRICORE_RIDER_A, INDICES},
  { "sat.b",      0, 0x00000032, 0xfffff0cd, F(SR),   1, "d",     "1",
		 TRICORE_RIDER_B_UP, INDICES},
  { "sat.b",      1, 0x05e0000b, 0x0a1ff0f4, F(RR),   2, "dd",    "14",
		 TRICORE_GENERIC, INDICES},
  { "sat.bu",     0, 0x000010d2, 0xffffe02d, F(SR),   1, "d",     "1",
		 TRICORE_RIDER_A, INDICES},
  { "sat.bu",     0, 0x00001032, 0xffffe0cd, F(SR),   1, "d",     "1",
		 TRICORE_RIDER_B_UP, INDICES},
  { "sat.bu",     1, 0x05f0000b, 0x0a0ff0f4, F(RR),   2, "dd",    "14",
		 TRICORE_GENERIC, INDICES},
  { "sat.h",      0, 0x000020d2, 0xffffd02d, F(SR),   1, "d",     "1",
		 TRICORE_RIDER_A, INDICES},
  { "sat.h",      0, 0x00002032, 0xffffd0cd, F(SR),   1, "d",     "1",
		 TRICORE_RIDER_B_UP, INDICES},
  { "sat.h",      1, 0x07e0000b, 0x081ff0f4, F(RR),   2, "dd",    "14",
		 TRICORE_GENERIC, INDICES},
  { "sat.hu",     0, 0x000030d2, 0xffffc02d, F(SR),   1, "d",     "1",
		 TRICORE_RIDER_A, INDICES},
  { "sat.hu",     0, 0x00003032, 0xffffc0cd, F(SR),   1, "d",     "1",
		 TRICORE_RIDER_B_UP, INDICES},
  { "sat.hu",     1, 0x07f0000b, 0x080ff0f4, F(RR),   2, "dd",    "14",
		 TRICORE_GENERIC, INDICES},
  { "sel",        1, 0x0040002b, 0x00bf00d4, F(RRR),  4, "dddd",  "1254",
		 TRICORE_GENERIC, INDICES},
  { "sel",        1, 0x008000ab, 0x00600054, F(RCR),  4, "ddd9",  "1243",
		 TRICORE_GENERIC, INDICES},
  { "sel.a",      1, 0x00400021, 0x00bf00de, F(RRR),  4, "adaa",  "1254",
		 TRICORE_RIDER_A, INDICES},
  { "sel.a",      1, 0x008000a1, 0x0060005e, F(RCR),  4, "ada9",  "1243",
		 TRICORE_RIDER_A, INDICES},
  { "seln",       1, 0x0050002b, 0x00af00d4, F(RRR),  4, "dddd",  "1254",
		 TRICORE_GENERIC, INDICES},
  { "seln",       1, 0x00a000ab, 0x00400054, F(RCR),  4, "ddd9",  "1243",
		 TRICORE_GENERIC, INDICES},
  { "seln.a",     1, 0x00500021, 0x00af00de, F(RRR),  4, "adaa",  "1254",
		 TRICORE_RIDER_A, INDICES},
  { "seln.a",     1, 0x00a000a1, 0x0040005e, F(RCR),  4, "ada9",  "1243",
		 TRICORE_RIDER_A, INDICES},
  { "sh",         0, 0x00000026, 0xffff00d9, F(SRC),  2, "d4",    "21",
		 TRICORE_RIDER_A, INDICES},
  { "sh",         0, 0x00000006, 0xffff00f9, F(SRC),  2, "d4",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "sh",         1, 0x0000000f, 0x0fff00f0, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "sh",         1, 0x0000008f, 0x0fe00070, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "sh.and.t",   1, 0x00000027, 0x006000d8, F(BIT),  5, "dd5d5", "15342",
		 TRICORE_GENERIC, INDICES},
  { "sh.andn.t",  1, 0x00600027, 0x000000d8, F(BIT),  5, "dd5d5", "15342",
		 TRICORE_GENERIC, INDICES},
  { "sh.b",       1, 0x0200000f, 0x0dff00f0, F(RR),   3, "ddd",   "143",
		 TRICORE_RIDER_A, INDICES},
  { "sh.b",       1, 0x0400008f, 0x0be00070, F(RC),   3, "dd9",   "132",
		 TRICORE_RIDER_A, INDICES},
  { "sh.eq",      1, 0x0370000b, 0x0c8f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "sh.eq",      1, 0x06e0008b, 0x09000074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "sh.ge",      1, 0x03b0000b, 0x0c4f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "sh.ge",      1, 0x0760008b, 0x08800074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "sh.ge.u",    1, 0x03c0000b, 0x0c3f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "sh.ge.u",    1, 0x0780008b, 0x08600074, F(RC),   3, "ddn",   "132",
		 TRICORE_GENERIC, INDICES},
  { "sh.h",       1, 0x0400000f, 0x0bff00f0, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "sh.h",       1, 0x0800008f, 0x07e00070, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "sh.lt",      1, 0x0390000b, 0x0c6f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "sh.lt",      1, 0x0720008b, 0x08c00074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "sh.lt.u",    1, 0x03a0000b, 0x0c5f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "sh.lt.u",    1, 0x0740008b, 0x08a00074, F(RC),   3, "ddn",   "132",
		 TRICORE_GENERIC, INDICES},
  { "sh.nand.t",  1, 0x000000a7, 0x00600058, F(BIT),  5, "dd5d5", "15342",
		 TRICORE_GENERIC, INDICES},
  { "sh.ne",      1, 0x0380000b, 0x0c7f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "sh.ne",      1, 0x0700008b, 0x08e00074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "sh.nor.t",   1, 0x00400027, 0x002000d8, F(BIT),  5, "dd5d5", "15342",
		 TRICORE_GENERIC, INDICES},
  { "sh.or.t",    1, 0x00200027, 0x004000d8, F(BIT),  5, "dd5d5", "15342",
		 TRICORE_GENERIC, INDICES},
  { "sh.orn.t",   1, 0x002000a7, 0x00400058, F(BIT),  5, "dd5d5", "15342",
		 TRICORE_GENERIC, INDICES},
  { "sh.xnor.t",  1, 0x004000a7, 0x00200058, F(BIT),  5, "dd5d5", "15342",
		 TRICORE_GENERIC, INDICES},
  { "sh.xor.t",   1, 0x006000a7, 0x00000058, F(BIT),  5, "dd5d5", "15342",
		 TRICORE_GENERIC, INDICES},
  { "sha",        0, 0x000000a6, 0xffff0059, F(SRC),  2, "d4",    "21",
		 TRICORE_RIDER_A, INDICES},
  { "sha",        0, 0x00000086, 0xffff0079, F(SRC),  2, "d4",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "sha",        1, 0x0010000f, 0x0fef00f0, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "sha",        1, 0x0020008f, 0x0fc00070, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "sha.b",      1, 0x0210000f, 0x0def00f0, F(RR),   3, "ddd",   "143",
		 TRICORE_RIDER_A, INDICES},
  { "sha.b",      1, 0x0420008f, 0x0bc00070, F(RC),   3, "dd9",   "132",
		 TRICORE_RIDER_A, INDICES},
  { "sha.h",      1, 0x0410000f, 0x0bef00f0, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "sha.h",      1, 0x0820008f, 0x07c00070, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "shas",       1, 0x0020000f, 0x0fdf00f0, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "shas",       1, 0x0040008f, 0x0fa00070, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "st.a",       0, 0x000000f8, 0xffff0007, F(SC),   3, "&kI",   "010",
  		 TRICORE_RIDER_B_UP, INDICES},
  { "st.a",       0, 0x00000018, 0xffff00e7, F(SRO),  3, "@6I",   "120",
		 TRICORE_RIDER_A, INDICES},
  { "st.a",       0, 0x000000ec, 0xffff0013, F(SRO),  3, "@6I",   "120",
		 TRICORE_RIDER_B_UP, INDICES},
  { "st.a",       0, 0x0000002c, 0xffff00d3, F(SSRO), 3, "S6a",   "012",
		 TRICORE_RIDER_A, INDICES},
  { "st.a",       0, 0x000000e8, 0xffff0017, F(SSRO), 3, "S6a",   "012",
		 TRICORE_RIDER_B_UP, INDICES},
  { "st.a",       0, 0x00000054, 0xffff00ab, F(SSR),  2, ">a",    "12",
		 TRICORE_RIDER_A, INDICES},
  { "st.a",       0, 0x000000e4, 0xffff001b, F(SSR),  2, ">a",    "12",
		 TRICORE_RIDER_B_UP, INDICES},
  { "st.a",       0, 0x00000084, 0xffff007b, F(SSR),  2, "@a",    "12",
		 TRICORE_RIDER_A, INDICES},
  { "st.a",       0, 0x000000f4, 0xffff000b, F(SSR),  2, "@a",    "12",
		 TRICORE_RIDER_B_UP, INDICES},
  { "st.a",       1, 0x01800089, 0x0e400076, F(BO),   3, ">0a",   "213",
		 TRICORE_GENERIC, INDICES},
  { "st.a",       1, 0x018000a9, 0xfe7f0056, F(BO),   2, "#a",    "23",
		 TRICORE_GENERIC, INDICES},
  { "st.a",       1, 0x05800089, 0x0a400076, F(BO),   3, "<0a",   "213",
		 TRICORE_GENERIC, INDICES},
  { "st.a",       1, 0x058000a9, 0x0a400056, F(BO),   3, "*0a",   "213",
		 TRICORE_GENERIC, INDICES},
  { "st.a",       1, 0x080000a5, 0x0400005a, F(ABS),  2, "ta",    "12",
		 TRICORE_GENERIC, INDICES},
  { "st.a",       1, 0x09800089, 0x06400076, F(BO),   3, "@0a",   "213",
		 TRICORE_GENERIC, INDICES},
  { "st.a",       1, 0x098000a9, 0xf67f0056, F(BO),   2, "?a",    "23",
  		 TRICORE_V2_UP, INDICES},
  { "st.b",       0, 0x00000078, 0xffff0087, F(SSR),  2, "@d",    "12",
		 TRICORE_RIDER_A, INDICES},
  { "st.b",       0, 0x00000034, 0xffff00cb, F(SSR),  2, "@d",    "12",
		 TRICORE_RIDER_B_UP, INDICES},
  { "st.b",       0, 0x0000008c, 0xffff0073, F(SSRO), 3, "Sfd",   "012",
		 TRICORE_RIDER_A, INDICES},
  { "st.b",       0, 0x00000028, 0xffff00d7, F(SSRO), 3, "Sfd",   "012",
		 TRICORE_RIDER_B_UP, INDICES},
  { "st.b",       0, 0x000000a8, 0xffff0057, F(SRO),  3, "@fi",   "120",
		 TRICORE_RIDER_A, INDICES},
  { "st.b",       0, 0x0000002c, 0xffff00d3, F(SRO),  3, "@fi",   "120",
		 TRICORE_RIDER_B_UP, INDICES},
  { "st.b",       0, 0x000000e4, 0xffff001b, F(SSR),  2, ">d",    "12",
		 TRICORE_RIDER_A, INDICES},
  { "st.b",       0, 0x00000024, 0xffff00db, F(SSR),  2, ">d",    "12",
		 TRICORE_RIDER_B_UP, INDICES},
  { "st.b",       1, 0x00000025, 0x0c0000da, F(ABS),  2, "td",    "12",
		 TRICORE_GENERIC, INDICES},
  { "st.b",       1, 0x000000e9, 0x00000016, F(BOL),  3, "@wd",   "213",
		 TRICORE_GENERIC, INDICES},
  { "st.b",       1, 0x00000089, 0x0fc00076, F(BO),   3, ">0d",   "213",
		 TRICORE_GENERIC, INDICES},
  { "st.b",       1, 0x000000a9, 0xffff0056, F(BO),   2, "#d",    "23",
		 TRICORE_GENERIC, INDICES},
  { "st.b",       1, 0x04000089, 0x0bc00076, F(BO),   3, "<0d",   "213",
		 TRICORE_GENERIC, INDICES},
  { "st.b",       1, 0x040000a9, 0x0bc00056, F(BO),   3, "*0d",   "213",
		 TRICORE_GENERIC, INDICES},
  { "st.b",       1, 0x08000089, 0x07c00076, F(BO),   3, "@0d",   "213",
		 TRICORE_GENERIC, INDICES},
  { "st.b",       1, 0x080000a9, 0xf7ff0056, F(BO),   2, "?d",    "23",
  		 TRICORE_V2_UP, INDICES},
  { "st.d",       1, 0x01400089, 0x0e800076, F(BO),   3, ">0D",   "213",
		 TRICORE_GENERIC, INDICES},
  { "st.d",       1, 0x014000a9, 0xfebf0056, F(BO),   2, "#D",    "23",
		 TRICORE_GENERIC, INDICES},
  { "st.d",       1, 0x040000a5, 0x0800005a, F(ABS),  2, "tD",    "12",
		 TRICORE_GENERIC, INDICES},
  { "st.d",       1, 0x05400089, 0x0a800076, F(BO),   3, "<0D",   "213",
		 TRICORE_GENERIC, INDICES},
  { "st.d",       1, 0x054000a9, 0x0a800056, F(BO),   3, "*0D",   "213",
		 TRICORE_GENERIC, INDICES},
  { "st.d",       1, 0x09400089, 0x06800076, F(BO),   3, "@0D",   "213",
		 TRICORE_GENERIC, INDICES},
  { "st.d",       1, 0x094000a9, 0xf6bf0056, F(BO),   2, "?D",    "23",
  		 TRICORE_V2_UP, INDICES},
  { "st.da",      1, 0x01c00089, 0x0e000076, F(BO),   3, ">0A",   "213",
		 TRICORE_GENERIC, INDICES},
  { "st.da",      1, 0x01c000a9, 0xfe3f0056, F(BO),   2, "#A",    "23",
		 TRICORE_GENERIC, INDICES},
  { "st.da",      1, 0x05c00089, 0x0a000076, F(BO),   3, "<0A",   "213",
		 TRICORE_GENERIC, INDICES},
  { "st.da",      1, 0x05c000a9, 0x0a000056, F(BO),   3, "*0A",   "213",
		 TRICORE_GENERIC, INDICES},
  { "st.da",      1, 0x09c00089, 0x06000076, F(BO),   3, "@0A",   "213",
		 TRICORE_GENERIC, INDICES},
  { "st.da",      1, 0x0c0000a5, 0x0000005a, F(ABS),  2, "tA",    "12",
		 TRICORE_GENERIC, INDICES},
  { "st.da",      1, 0x09c000a9, 0xf63f0056, F(BO),   2, "?A",    "23",
  		 TRICORE_V2_UP, INDICES},
  { "st.dd",      1, 0x02400089, 0x0d800076, F(BO),   3, ">0D",   "213",
  		 TRICORE_V2_UP, INDICES},
  { "st.dd",      1, 0x024000a9, 0xfdbf0056, F(BO),   2, "#D",    "23",
  		 TRICORE_V2_UP, INDICES},
  { "st.dd",      1, 0x06400089, 0x09800076, F(BO),   3, "<0D",   "213",
  		 TRICORE_V2_UP, INDICES},
  { "st.dd",      1, 0x064000a9, 0x09800056, F(BO),   3, "*0D",   "213",
  		 TRICORE_V2_UP, INDICES},
  { "st.dd",      1, 0x0a400089, 0x05800076, F(BO),   3, "@0D",   "213",
  		 TRICORE_V2_UP, INDICES},
  { "st.dd",      1, 0x0a4000a9, 0xf5bf0056, F(BO),   2, "?D",    "23",
  		 TRICORE_V2_UP, INDICES},
  { "st.h",       0, 0x00000014, 0xffff00eb, F(SSR),  2, ">d",    "12",
		 TRICORE_RIDER_A, INDICES},
  { "st.h",       0, 0x000000a4, 0xffff005b, F(SSR),  2, ">d",    "12",
		 TRICORE_RIDER_B_UP, INDICES},
  { "st.h",       0, 0x0000004c, 0xffff00b3, F(SSRO), 3, "Svd",   "012",
		 TRICORE_RIDER_A, INDICES},
  { "st.h",       0, 0x000000a8, 0xffff0057, F(SSRO), 3, "Svd",   "012",
		 TRICORE_RIDER_B_UP, INDICES},
  { "st.h",       0, 0x00000068, 0xffff0097, F(SRO),  3, "@vi",   "120",
		 TRICORE_RIDER_A, INDICES},
  { "st.h",       0, 0x000000ac, 0xffff0053, F(SRO),  3, "@vi",   "120",
		 TRICORE_RIDER_B_UP, INDICES},
  { "st.h",       0, 0x000000f8, 0xffff0007, F(SSR),  2, "@d",    "12",
		 TRICORE_RIDER_A, INDICES},
  { "st.h",       0, 0x000000b4, 0xffff004b, F(SSR),  2, "@d",    "12",
		 TRICORE_RIDER_B_UP, INDICES},
  { "st.h",       1, 0x00800089, 0x0f400076, F(BO),   3, ">0d",   "213",
		 TRICORE_GENERIC, INDICES},
  { "st.h",       1, 0x008000a9, 0xff7f0056, F(BO),   2, "#d",    "23",
		 TRICORE_GENERIC, INDICES},
  { "st.h",       1, 0x04800089, 0x0b400076, F(BO),   3, "<0d",   "213",
		 TRICORE_GENERIC, INDICES},
  { "st.h",       1, 0x048000a9, 0x0b400056, F(BO),   3, "*0d",   "213",
		 TRICORE_GENERIC, INDICES},
  { "st.h",       1, 0x08000025, 0x040000da, F(ABS),  2, "td",    "12",
		 TRICORE_GENERIC, INDICES},
  { "st.h",       1, 0x08800089, 0x07400076, F(BO),   3, "@0d",   "213",
		 TRICORE_GENERIC, INDICES},
  { "st.h",       1, 0x088000a9, 0xf77f0056, F(BO),   2, "?d",    "23",
  		 TRICORE_V2_UP, INDICES},
  { "st.q",       1, 0x00000065, 0x0c00009a, F(ABS),  2, "td",    "12",
		 TRICORE_GENERIC, INDICES},
  { "st.q",       1, 0x02000089, 0x0dc00076, F(BO),   3, ">0d",   "213",
		 TRICORE_GENERIC, INDICES},
  { "st.q",       1, 0x020000a9, 0xfdff0056, F(BO),   2, "#d",    "23",
		 TRICORE_GENERIC, INDICES},
  { "st.q",       1, 0x06000089, 0x09c00076, F(BO),   3, "<0d",   "213",
		 TRICORE_GENERIC, INDICES},
  { "st.q",       1, 0x060000a9, 0x09c00056, F(BO),   3, "*0d",   "213",
		 TRICORE_GENERIC, INDICES},
  { "st.q",       1, 0x0a000089, 0x05c00076, F(BO),   3, "@0d",   "213",
		 TRICORE_GENERIC, INDICES},
  { "st.q",       1, 0x0a0000a9, 0xf5ff0056, F(BO),   2, "?d",    "23",
  		 TRICORE_V2_UP, INDICES},
  { "st.t",       1, 0x000000d5, 0x0c00002a, F(ABSB), 3, "t31",   "132",
		 TRICORE_GENERIC, INDICES},
  { "st.w",       0, 0x00000078, 0xffff0087, F(SC),   3, "&ki",   "010",
		 TRICORE_RIDER_B_UP, INDICES},
  { "st.w",       0, 0x00000004, 0xffff00fb, F(SSR),  2, "@d",    "12",
		 TRICORE_RIDER_A, INDICES},
  { "st.w",       0, 0x00000074, 0xffff008b, F(SSR),  2, "@d",    "12",
		 TRICORE_RIDER_B_UP, INDICES},
  { "st.w",       0, 0x00000094, 0xffff006b, F(SSR),  2, ">d",    "12",
		 TRICORE_RIDER_A, INDICES},
  { "st.w",       0, 0x00000064, 0xffff009b, F(SSR),  2, ">d",    "12",
		 TRICORE_RIDER_B_UP, INDICES},
  { "st.w",       0, 0x000000cc, 0xffff0033, F(SSRO), 3, "S6d",   "012",
		 TRICORE_RIDER_A, INDICES},
  { "st.w",       0, 0x00000068, 0xffff0097, F(SSRO), 3, "S6d",   "012",
		 TRICORE_RIDER_B_UP, INDICES},
  { "st.w",       0, 0x000000e8, 0xffff0017, F(SRO),  3, "@6i",   "120",
		 TRICORE_RIDER_A, INDICES},
  { "st.w",       0, 0x0000006c, 0xffff0093, F(SRO),  3, "@6i",   "120",
		 TRICORE_RIDER_B_UP, INDICES},
  { "st.w",       1, 0x00000059, 0x000000a6, F(BOL),  3, "@wd",   "213",
		 TRICORE_GENERIC, INDICES},
  { "st.w",       1, 0x000000a5, 0x0c00005a, F(ABS),  2, "td",    "12",
		 TRICORE_GENERIC, INDICES},
  { "st.w",       1, 0x01000089, 0x0ec00076, F(BO),   3, ">0d",   "213",
		 TRICORE_GENERIC, INDICES},
  { "st.w",       1, 0x010000a9, 0xfeff0056, F(BO),   2, "#d",    "23",
		 TRICORE_GENERIC, INDICES},
  { "st.w",       1, 0x05000089, 0x0ac00076, F(BO),   3, "<0d",   "213",
		 TRICORE_GENERIC, INDICES},
  { "st.w",       1, 0x050000a9, 0x0ac00056, F(BO),   3, "*0d",   "213",
		 TRICORE_GENERIC, INDICES},
  { "st.w",       1, 0x09000089, 0x06c00076, F(BO),   3, "@0d",   "213",
		 TRICORE_GENERIC, INDICES},
  { "st.w",       1, 0x090000a9, 0xf6ff0056, F(BO),   2, "?d",    "23",
  		 TRICORE_V2_UP, INDICES},
  { "stlcx",      1, 0x00000015, 0x0c000fea, F(ABS),  1, "t",     "1",
		 TRICORE_GENERIC, INDICES},
  { "stlcx",      1, 0x09800049, 0x06400fb6, F(BO),   2, "@0",    "21",
		 TRICORE_GENERIC, INDICES},
  { "stucx",      1, 0x04000015, 0x08000fea, F(ABS),  1, "t",     "1",
		 TRICORE_GENERIC, INDICES},
  { "stucx",      1, 0x09c00049, 0x06000fb6, F(BO),   2, "@0",    "21",
		 TRICORE_GENERIC, INDICES},
  { "sub",        0, 0x00000052, 0xffff00ad, F(SRR),  3, "did",   "201",
		 TRICORE_RIDER_B_UP, INDICES},
  { "sub",        0, 0x0000005a, 0xffff00a5, F(SRR),  3, "idd",   "021",
		 TRICORE_GENERIC, INDICES},
  { "sub",        0, 0x000000a2, 0xffff005d, F(SRR),  2, "dd",    "21",
		 TRICORE_GENERIC, INDICES},
  { "sub",        1, 0x0080000b, 0x0f7f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "sub.a",      0, 0x00000040, 0xffff00bf, F(SC),   2, "P8",    "01",
		 TRICORE_RIDER_A, INDICES},
  { "sub.a",      0, 0x00000020, 0xffff00df, F(SC),   2, "P8",    "01",
		 TRICORE_RIDER_B_UP, INDICES},
  { "sub.a",      1, 0x00200001, 0x0fdf00fe, F(RR),   3, "aaa",   "143",
		 TRICORE_GENERIC, INDICES},
  { "sub.b",      1, 0x0480000b, 0x0b7f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "sub.f",      1, 0x0031006b, 0x00cef094, F(RRR),  3, "ddd",   "125",
		 TRICORE_RIDER_D_UP, INDICES},
  { "sub.h",      1, 0x0680000b, 0x097f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "subc",       1, 0x00d0000b, 0x0f2f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "subs",       0, 0x00000062, 0xffff009d, F(SRR),  2, "dd",    "21",
		 TRICORE_GENERIC, INDICES},
  { "subs",       1, 0x00a0000b, 0x0f5f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "subs.b",     1, 0x04a0000b, 0x0b5f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_RIDER_A, INDICES},
  { "subs.bu",    1, 0x04b0000b, 0x0b4f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_RIDER_A, INDICES},
  { "subs.h",     1, 0x06a0000b, 0x095f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "subs.hu",    1, 0x06b0000b, 0x094f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "subs.u",     1, 0x00b0000b, 0x0f4f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "subsc.a",    1, 0x06100001, 0x09ec00fe, F(RR),   4, "aad2",  "1432",
		 TRICORE_RIDER_A, INDICES},
  { "subx",       1, 0x00c0000b, 0x0f3f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "svlcx",      1, 0x0200000d, 0xfdfffff2, F(SYS),  0, "",      "",
		 TRICORE_GENERIC, INDICES},
  { "swap.a",     1, 0x00800049, 0x0f4000b6, F(BO),   3, ">0a",   "213",
		 TRICORE_RIDER_A, INDICES},
  { "swap.a",     1, 0x00800069, 0xff7f0096, F(BO),   2, "#a",    "23",
		 TRICORE_RIDER_A, INDICES},
  { "swap.a",     1, 0x04800049, 0x0b4000b6, F(BO),   3, "<0a",   "213",
		 TRICORE_RIDER_A, INDICES},
  { "swap.a",     1, 0x04800069, 0x0b400096, F(BO),   3, "*0a",   "213",
		 TRICORE_RIDER_A, INDICES},
  { "swap.a",     1, 0x080000e5, 0x0400001a, F(ABS),  2, "ta",    "12",
		 TRICORE_RIDER_A, INDICES},
  { "swap.a",     1, 0x08800049, 0x074000b6, F(BO),   3, "@0a",   "213",
		 TRICORE_RIDER_A, INDICES},
  { "swap.w",     1, 0x00000049, 0x0fc000b6, F(BO),   3, ">0d",   "213",
		 TRICORE_GENERIC, INDICES},
  { "swap.w",     1, 0x00000069, 0xffff0096, F(BO),   2, "#d",    "23",
		 TRICORE_GENERIC, INDICES},
  { "swap.w",     1, 0x000000e5, 0x0c00001a, F(ABS),  2, "td",    "12",
		 TRICORE_GENERIC, INDICES},
  { "swap.w",     1, 0x04000049, 0x0bc000b6, F(BO),   3, "<0d",   "213",
		 TRICORE_GENERIC, INDICES},
  { "swap.w",     1, 0x04000069, 0x0bc00096, F(BO),   3, "*0d",   "213",
		 TRICORE_GENERIC, INDICES},
  { "swap.w",     1, 0x08000049, 0x07c000b6, F(BO),   3, "@0d",   "213",
		 TRICORE_GENERIC, INDICES},
  { "swap.w",     1, 0x08000069, 0xf7ff0096, F(BO),   2, "?d",    "23",
  		 TRICORE_V2_UP, INDICES},
  { "swapmsk",    1, 0x00800049, 0x0f4000b6, F(BO),   3, ">0D",   "213",
  		 TRICORE_V2_UP, INDICES},
  { "swapmsk",    1, 0x00800069, 0xff7f0096, F(BO),   2, "#D",    "23",
  		 TRICORE_V2_UP, INDICES},
  { "swapmsk",    1, 0x04800049, 0x0b4000b6, F(BO),   3, "<0D",   "213",
  		 TRICORE_V2_UP, INDICES},
  { "swapmsk",    1, 0x04800069, 0x0b400096, F(BO),   3, "*0D",   "213",
  		 TRICORE_V2_UP, INDICES},
  { "swapmsk",    1, 0x08800049, 0x074000b6, F(BO),   3, "@0D",   "213",
  		 TRICORE_V2_UP, INDICES},
  { "swapmsk",    1, 0x08800069, 0xf77f0096, F(BO),   2, "?D",    "23",
  		 TRICORE_V2_UP, INDICES},
  { "syscall",    1, 0x008000ad, 0xff600f52, F(RC),   1, "n",     "2",
		 TRICORE_GENERIC, INDICES},
  { "tlbdemap",   1, 0x00000075, 0xfffff08a, F(RR),   1, "d",     "4",
		 TRICORE_RIDER_D_UP, INDICES},
  { "tlbflush.a", 1, 0x00400075, 0xffbfff8a, F(RR),   0, "",      "",
		 TRICORE_RIDER_D_UP, INDICES},
  { "tlbflush.b", 1, 0x00500075, 0xffafff8a, F(RR),   0, "",      "",
		 TRICORE_RIDER_D_UP, INDICES},
  { "tlbmap",     1, 0x04000075, 0xfbfff08a, F(RR),   1, "D",     "4",
		 TRICORE_RIDER_D_UP, INDICES},
  { "tlbprobe.a", 1, 0x00800075, 0xff7ff08a, F(RR),   1, "d",     "4",
		 TRICORE_RIDER_D_UP, INDICES},
  { "tlbprobe.i", 1, 0x00900075, 0xff6ff08a, F(RR),   1, "d",     "4",
		 TRICORE_RIDER_D_UP, INDICES},
  { "trapsv",     1, 0x0540000d, 0xfabffff2, F(SYS),  0, "",      "",
		 TRICORE_GENERIC, INDICES},
  { "trapv",      1, 0x0500000d, 0xfafffff2, F(SYS),  0, "",      "",
		 TRICORE_GENERIC, INDICES},
  { "unpack",     1, 0x0500004b, 0x0afff0b4, F(RR),   2, "Dd",    "14",
		 TRICORE_RIDER_A, INDICES},
  { "unpack",     1, 0x0080004b, 0x0f7ff0b4, F(RR),   2, "Dd",    "14",
		 TRICORE_RIDER_B_UP, INDICES},
  { "updfl",      1, 0x00c1004b, 0xff3ef0b4, F(RR),   1, "d",     "4",
		 TRICORE_RIDER_D_UP, INDICES},
  { "utof",       1, 0x0161004b, 0x0e9ef0b4, F(RR),   2, "dd",    "14",
		 TRICORE_RIDER_D_UP, INDICES},
  { "xnor",       1, 0x00d0000f, 0x0f2f00f0, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "xnor",       1, 0x01a0008f, 0x0e400070, F(RC),   3, "ddn",   "132",
		 TRICORE_GENERIC, INDICES},
  { "xnor.t",     1, 0x00400007, 0x002000f8, F(BIT),  5, "dd5d5", "15342",
		 TRICORE_GENERIC, INDICES},
  { "xor",        0, 0x000000c6, 0xffff0039, F(SRR),  2, "dd",    "21",
		 TRICORE_RIDER_B_UP, INDICES},
  { "xor",        1, 0x00c0000f, 0x0f3f00f0, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "xor",        1, 0x0180008f, 0x0e600070, F(RC),   3, "ddn",   "132",
		 TRICORE_GENERIC, INDICES},
  { "xor.eq",     1, 0x02f0000b, 0x0d0f00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "xor.eq",     1, 0x05e0008b, 0x0a000074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "xor.ge",     1, 0x0330000b, 0x0ccf00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "xor.ge",     1, 0x0660008b, 0x09800074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "xor.ge.u",   1, 0x0340000b, 0x0cbf00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "xor.ge.u",   1, 0x0680008b, 0x09600074, F(RC),   3, "ddn",   "132",
		 TRICORE_GENERIC, INDICES},
  { "xor.lt",     1, 0x0310000b, 0x0cef00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "xor.lt",     1, 0x0620008b, 0x09c00074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "xor.lt.u",   1, 0x0320000b, 0x0cdf00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "xor.lt.u",   1, 0x0640008b, 0x09a00074, F(RC),   3, "ddn",   "132",
		 TRICORE_GENERIC, INDICES},
  { "xor.ne",     1, 0x0300000b, 0x0cff00f4, F(RR),   3, "ddd",   "143",
		 TRICORE_GENERIC, INDICES},
  { "xor.ne",     1, 0x0600008b, 0x09e00074, F(RC),   3, "dd9",   "132",
		 TRICORE_GENERIC, INDICES},
  { "xor.t",      1, 0x00600007, 0x000000f8, F(BIT),  5, "dd5d5", "15342",
		 TRICORE_GENERIC, INDICES},
  { "xpose.b",    1, 0x0830000b, 0x07cf00f4, F(RR),   3, "Ddd",   "143",
  		 TRICORE_V2_UP, INDICES},
  { "xpose.h",    1, 0x0820000b, 0x07df00f4, F(RR),   3, "Ddd",   "143",
  		 TRICORE_V2_UP, INDICES}
#undef INDICES
};

const int tricore_numopcodes =
  sizeof tricore_opcodes / sizeof tricore_opcodes[0];

/* Here are the opcodes for the PCP.  The assembler requires that all
   instances of the same mnemonic must be consecutive.  If they aren't,
   the assembler will bomb at runtime.  The disassembler shouldn't care,
   though.  */

struct pcp_opcode pcp_opcodes[] =
{
#define INDICES TRICORE_PCP, 0, 0
  { "add",	0, 0x6000, 0x9e00, 3, 0, 3, "arr",   INDICES},
  { "add",	0, 0x6000, 0x9e00, 3, 0, 3, "rra",   INDICES},
  { "add.f",	0, 0x2000, 0xde04, 1, 0, 3, "rRf",   INDICES},
  { "add.f",	0, 0x2000, 0xde04, 1, 0, 3, "rrf",   INDICES},
  { "add.i",	0, 0x8000, 0x7e00, 4, 0, 2, "re",    INDICES},
  { "add.pi",	0, 0x4000, 0xbe00, 2, 0, 2, "rE",    INDICES},
  { "add.pi",	0, 0x4000, 0xbe00, 2, 0, 2, "re",    INDICES},
  { "and",	0, 0x6a00, 0x9400, 3, 0, 3, "arr",   INDICES},
  { "and",	0, 0x6a00, 0x9400, 3, 0, 3, "rra",   INDICES},
  { "and.f",	0, 0x2a00, 0xd404, 1, 0, 3, "rRf",   INDICES},
  { "and.f",	0, 0x2a00, 0xd404, 1, 0, 3, "rrf",   INDICES},
  { "and.pi",	0, 0x4a00, 0xb400, 2, 0, 2, "rE",    INDICES},
  { "and.pi",	0, 0x4a00, 0xb400, 2, 0, 2, "re",    INDICES},
  { "bcopy",	0, 0x1800, 0xe013, 0, 1, 4, "dscn",  INDICES},
  { "chkb",	0, 0x9c00, 0x6200, 4, 0, 3, "rel",   INDICES},
  { "chkb",	0, 0x9c20, 0x6220, 4, 0, 3, "rek",   INDICES},
  { "clr",	0, 0x9600, 0x6820, 4, 0, 2, "re",    INDICES},
  { "clr.f",	0, 0xb000, 0x4c00, 5, 0, 3, "Ref",   INDICES},
  { "clr.f",	0, 0xb000, 0x4c00, 5, 0, 3, "ref",   INDICES},
  { "comp",	0, 0x6400, 0x9a00, 3, 0, 3, "arr",   INDICES},
  { "comp",	0, 0x6400, 0x9a00, 3, 0, 3, "rra",   INDICES},
  { "comp.f",	0, 0x2400, 0xda04, 1, 0, 3, "rRf",   INDICES},
  { "comp.f",	0, 0x2400, 0xda04, 1, 0, 3, "rrf",   INDICES},
  { "comp.i",	0, 0x8400, 0x7a00, 4, 0, 2, "re",    INDICES},
  { "comp.pi",	0, 0x4400, 0xba00, 2, 0, 2, "rE",    INDICES},
  { "comp.pi",	0, 0x4400, 0xba00, 2, 0, 2, "re",    INDICES},
  { "copy",	0, 0x0800, 0xf000, 0, 1, 5, "dscnf", INDICES},
  { "debug",	0, 0xfc00, 0x0030, 7, 1, 5, "bmopq", INDICES},
  { "debug",	0, 0xfc00, 0x0030, 7, 1, 5, "amopq", INDICES},
  { "dinit",	0, 0xc000, 0x3e07, 6, 0, 2, "rr",    INDICES},
  { "dstep",	0, 0xc200, 0x3c07, 6, 0, 2, "rr",    INDICES},
  { "exb",	0, 0x9c20, 0x6200, 4, 0, 2, "re",    INDICES},
  { "exib",	0, 0x9c00, 0x6220, 4, 0, 2, "re",    INDICES},
  { "exit",      0, 0x1000, 0xe870, 0, 1, 5, "ghijb", INDICES},
  { "exit",      0, 0x1000, 0xe870, 0, 1, 5, "ghija", INDICES},
  { "inb",	0, 0x7a00, 0x8400, 3, 0, 3, "arr",   INDICES},
  { "inb",	0, 0x7a00, 0x8400, 3, 0, 3, "rra",   INDICES},
  { "inb.i",	0, 0x9a00, 0x6420, 4, 0, 2, "re",    INDICES},
  { "jc",	0, 0xe400, 0x1800, 7, 1, 2, "be",    INDICES},
  { "jc",	0, 0xe400, 0x1800, 7, 1, 2, "ae",    INDICES},
  { "jc.a",	1, 0xe800, 0x143f, 7, 1, 2, "be",    INDICES},
  { "jc.a",	1, 0xe800, 0x143f, 7, 1, 2, "ae",    INDICES},
  { "jc.i",	0, 0xf000, 0x0c07, 7, 1, 2, "bR",    INDICES},
  { "jc.i",	0, 0xf000, 0x0c07, 7, 1, 2, "br",    INDICES},
  { "jc.i",	0, 0xf000, 0x0c07, 7, 1, 2, "aR",    INDICES},
  { "jc.i",	0, 0xf000, 0x0c07, 7, 1, 2, "ar",    INDICES},
  { "jc.ia",	0, 0xf400, 0x0807, 7, 1, 2, "bR",    INDICES},
  { "jc.ia",	0, 0xf400, 0x0807, 7, 1, 2, "br",    INDICES},
  { "jc.ia",	0, 0xf400, 0x0807, 7, 1, 2, "aR",    INDICES},
  { "jc.ia",	0, 0xf400, 0x0807, 7, 1, 2, "ar",    INDICES},
  { "jl",	0, 0xe000, 0x1c00, 7, 0, 1, "e",     INDICES},
  { "ld.f",	0, 0x3200, 0xcc04, 1, 0, 3, "rRf",   INDICES},
  { "ld.f",	0, 0x3200, 0xcc04, 1, 0, 3, "rrf",   INDICES},
  { "ld.i",	0, 0x9800, 0x6600, 4, 0, 2, "re",    INDICES},
  { "ld.if",	0, 0xb400, 0x4800, 5, 0, 3, "Ref",   INDICES},
  { "ld.if",	0, 0xb400, 0x4800, 5, 0, 3, "ref",   INDICES},
  { "ld.p",	0, 0x7200, 0x8c00, 3, 0, 3, "arR",   INDICES},
  { "ld.p",	0, 0x7200, 0x8c00, 3, 0, 3, "arr",   INDICES},
  { "ld.p",	0, 0x7200, 0x8c00, 3, 0, 3, "rRa",   INDICES},
  { "ld.p",	0, 0x7200, 0x8c00, 3, 0, 3, "rra",   INDICES},
  { "ld.pi",	0, 0x5200, 0xac00, 2, 0, 2, "rE",    INDICES},
  { "ld.pi",	0, 0x5200, 0xac00, 2, 0, 2, "re",    INDICES},
  { "ldl.il",	1, 0x9200, 0x6c3f, 4, 0, 2, "re",    INDICES},
  { "ldl.iu",	1, 0x9000, 0x6e3f, 4, 0, 2, "re",    INDICES},
  { "mclr.pi",	0, 0x4800, 0xb600, 2, 0, 2, "rE",    INDICES},
  { "mclr.pi",	0, 0x4800, 0xb600, 2, 0, 2, "re",    INDICES},
  { "minit",	0, 0xc400, 0x3a07, 6, 0, 2, "rr",    INDICES},
  { "mov",	0, 0x7800, 0x8600, 3, 0, 3, "arr",   INDICES},
  { "mov",	0, 0x7800, 0x8600, 3, 0, 3, "rra",   INDICES},
  { "mset.pi",	0, 0x4c00, 0xb200, 2, 0, 2, "rE",    INDICES},
  { "mset.pi",	0, 0x4c00, 0xb200, 2, 0, 2, "re",    INDICES},
  { "mstep.l",	0, 0xc600, 0x3807, 6, 0, 2, "rr",    INDICES},
  { "mstep.u",	0, 0xc800, 0x3607, 6, 0, 2, "rr",    INDICES},
  { "mstep32",	0, 0xc600, 0x3807, 6, 0, 2, "rr",    INDICES},
  { "mstep64",	0, 0xc800, 0x3607, 6, 0, 2, "rr",    INDICES},
  { "neg",	0, 0x6600, 0x9800, 3, 0, 3, "arr",   INDICES},
  { "neg",	0, 0x6600, 0x9800, 3, 0, 3, "rra",   INDICES},
  { "nop",	0, 0x0000, 0xffff, 0, 0, 0, "",      INDICES},
  { "not",	0, 0x6800, 0x9600, 3, 0, 3, "arr",   INDICES},
  { "not",	0, 0x6800, 0x9600, 3, 0, 3, "rra",   INDICES},
  { "or",	0, 0x6e00, 0x9000, 3, 0, 3, "arr",   INDICES},
  { "or",	0, 0x6e00, 0x9000, 3, 0, 3, "rra",   INDICES},
  { "or.f",	0, 0x2e00, 0xd004, 1, 0, 3, "rRf",   INDICES},
  { "or.f",	0, 0x2e00, 0xd004, 1, 0, 3, "rrf",   INDICES},
  { "or.pi",	0, 0x4e00, 0xb000, 2, 0, 2, "rE",    INDICES},
  { "or.pi",	0, 0x4e00, 0xb000, 2, 0, 2, "re",    INDICES},
  { "pri",	0, 0x7c00, 0x8200, 3, 0, 3, "arr",   INDICES},
  { "pri",	0, 0x7c00, 0x8200, 3, 0, 3, "rra",   INDICES},
  { "rl",	0, 0x8e00, 0x7020, 4, 0, 2, "re",    INDICES},
  { "rr",	0, 0x8c00, 0x7220, 4, 0, 2, "re",    INDICES},
  { "set",	0, 0x9400, 0x6a20, 4, 0, 2, "re",    INDICES},
  { "set.f",	0, 0xac00, 0x5000, 5, 0, 3, "Ref",   INDICES},
  { "set.f",	0, 0xac00, 0x5000, 5, 0, 3, "ref",   INDICES},
  { "shl",	0, 0x8a00, 0x7420, 4, 0, 2, "re",    INDICES},
  { "shr",	0, 0x8800, 0x7620, 4, 0, 2, "re",    INDICES},
  { "st.f",	0, 0x3400, 0xca04, 1, 0, 3, "rRf",   INDICES},
  { "st.f",	0, 0x3400, 0xca04, 1, 0, 3, "rrf",   INDICES},
  { "st.if",	0, 0xb800, 0x4400, 5, 0, 3, "Ref",   INDICES},
  { "st.if",	0, 0xb800, 0x4400, 5, 0, 3, "ref",   INDICES},
  { "st.p",	0, 0x7400, 0x8a00, 3, 0, 3, "arR",   INDICES},
  { "st.p",	0, 0x7400, 0x8a00, 3, 0, 3, "arr",   INDICES},
  { "st.p",	0, 0x7400, 0x8a00, 3, 0, 3, "rRa",   INDICES},
  { "st.p",	0, 0x7400, 0x8a00, 3, 0, 3, "rra",   INDICES},
  { "st.pi",	0, 0x5400, 0xaa00, 2, 0, 2, "rE",    INDICES},
  { "st.pi",	0, 0x5400, 0xaa00, 2, 0, 2, "re",    INDICES},
  { "sub",	0, 0x6200, 0x9c00, 3, 0, 3, "arr",   INDICES},
  { "sub",	0, 0x6200, 0x9c00, 3, 0, 3, "rra",   INDICES},
  { "sub.f",	0, 0x2200, 0xdc04, 1, 0, 3, "rRf",   INDICES},
  { "sub.f",	0, 0x2200, 0xdc04, 1, 0, 3, "rrf",   INDICES},
  { "sub.i",	0, 0x8200, 0x7c00, 4, 0, 2, "re",    INDICES},
  { "sub.pi",	0, 0x4200, 0xbc00, 2, 0, 2, "rE",    INDICES},
  { "sub.pi",	0, 0x4200, 0xbc00, 2, 0, 2, "re",    INDICES},
  { "xch.f",	0, 0x3600, 0xc804, 1, 0, 3, "rRf",   INDICES},
  { "xch.f",	0, 0x3600, 0xc804, 1, 0, 3, "rrf",   INDICES},
  { "xch.pi",	0, 0x5600, 0xa800, 2, 0, 2, "rE",    INDICES},
  { "xch.pi",	0, 0x5600, 0xa800, 2, 0, 2, "re",    INDICES},
  { "xor",	0, 0x7000, 0x8e00, 3, 0, 3, "arr",   INDICES},
  { "xor",	0, 0x7000, 0x8e00, 3, 0, 3, "rra",   INDICES},
  { "xor.f",	0, 0x3000, 0xce04, 1, 0, 3, "rRf",   INDICES},
  { "xor.f",	0, 0x3000, 0xce04, 1, 0, 3, "rrf",   INDICES},
  { "xor.pi",	0, 0x5000, 0xae00, 2, 0, 2, "rE",    INDICES},
  { "xor.pi",	0, 0x5000, 0xae00, 2, 0, 2, "re",    INDICES}
#undef INDICES
};

const int pcp_numopcodes = sizeof pcp_opcodes / sizeof pcp_opcodes[0];

/* End of tricore-opc.c.  */
