% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn.R
\name{new_function}
\alias{new_function}
\title{Create a function}
\usage{
new_function(args, body, env = caller_env())
}
\arguments{
\item{args}{A named list or pairlist of default arguments. Note
that if you want arguments that don't have defaults, you'll need
to use the special function \code{\link[=pairlist2]{pairlist2()}}. If you need quoted
defaults, use \code{\link[=exprs]{exprs()}}.}

\item{body}{A language object representing the code inside the
function. Usually this will be most easily generated with
\code{\link[base:substitute]{base::quote()}}}

\item{env}{The parent environment of the function, defaults to the
calling environment of \code{new_function()}}
}
\description{
This constructs a new function given its three components:
list of arguments, body code and parent environment.
}
\examples{
f <- function() letters
g <- new_function(NULL, quote(letters))
identical(f, g)

# Pass a list or pairlist of named arguments to create a function
# with parameters. The name becomes the parameter name and the
# argument the default value for this parameter:
new_function(list(x = 10), quote(x))
new_function(pairlist2(x = 10), quote(x))

# Use `exprs()` to create quoted defaults. Compare:
new_function(pairlist2(x = 5 + 5), quote(x))
new_function(exprs(x = 5 + 5), quote(x))

# Pass empty arguments to omit defaults. `list()` doesn't allow
# empty arguments but `pairlist2()` does:
new_function(pairlist2(x = , y = 5 + 5), quote(x + y))
new_function(exprs(x = , y = 5 + 5), quote(x + y))
}
