% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{constant}
\alias{constant}
\title{Constant priors in \pkg{brms}}
\usage{
constant(const, broadcast = TRUE)
}
\arguments{
\item{const}{Numeric value, vector, matrix of values to which the parameters
should be fixed to. Can also be a valid Stan variable in the model.}

\item{broadcast}{Should \code{const} be automatically broadcasted to the
correct size of the parameter? Defaults to \code{TRUE}. If you supply
vectors or matrices in \code{const} or vector/matrix valued Stan variables,
you need to set \code{broadcast} to \code{TRUE} (see Examples).}
}
\value{
A named list with elements \code{const} and \code{broadcast}.
}
\description{
Function used to set up constant priors in \pkg{brms}.
The function does not evaluate its arguments -- it exists purely
to help set up the model.
}
\examples{
stancode(count ~ Base + Age, data = epilepsy,
         prior = prior(constant(1), class = "b"))

# will fail parsing because brms will try to broadcast a vector into a vector
stancode(count ~ Base + Age, data = epilepsy,
         prior = prior(constant(alpha), class = "b"),
         stanvars = stanvar(c(1, 0), name = "alpha"))

stancode(count ~ Base + Age, data = epilepsy,
         prior = prior(constant(alpha, broadcast = FALSE), class = "b"),
         stanvars = stanvar(c(1, 0), name = "alpha"))

}
\seealso{
\code{\link{set_prior}}
}
