
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_lobpcg.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LOBPCGCreate_pre( HYPRE_Precision precision, mv_InterfaceInterpreter *interpreter, HYPRE_MatvecFunctions *mvfunctions, HYPRE_Solver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LOBPCGCreate_flt( interpreter, mvfunctions, solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LOBPCGCreate_dbl( interpreter, mvfunctions, solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LOBPCGCreate_long_dbl( interpreter, mvfunctions, solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LOBPCGDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LOBPCGDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LOBPCGDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LOBPCGDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

utilities_FortranMatrix*
HYPRE_LOBPCGEigenvaluesHistory_pre( HYPRE_Precision precision, HYPRE_Solver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LOBPCGEigenvaluesHistory_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LOBPCGEigenvaluesHistory_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LOBPCGEigenvaluesHistory_long_dbl( solver );
      default:
         { utilities_FortranMatrix* value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LOBPCGGetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver *precond_data_ptr )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LOBPCGGetPrecond_flt( solver, precond_data_ptr );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LOBPCGGetPrecond_dbl( solver, precond_data_ptr );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LOBPCGGetPrecond_long_dbl( solver, precond_data_ptr );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LOBPCGIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LOBPCGIterations_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LOBPCGIterations_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LOBPCGIterations_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

utilities_FortranMatrix*
HYPRE_LOBPCGResidualNorms_pre( HYPRE_Precision precision, HYPRE_Solver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LOBPCGResidualNorms_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LOBPCGResidualNorms_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LOBPCGResidualNorms_long_dbl( solver );
      default:
         { utilities_FortranMatrix* value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

utilities_FortranMatrix*
HYPRE_LOBPCGResidualNormsHistory_pre( HYPRE_Precision precision, HYPRE_Solver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LOBPCGResidualNormsHistory_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LOBPCGResidualNormsHistory_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LOBPCGResidualNormsHistory_long_dbl( solver );
      default:
         { utilities_FortranMatrix* value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LOBPCGSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LOBPCGSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LOBPCGSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LOBPCGSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LOBPCGSetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToSolverFcn precond, HYPRE_PtrToSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LOBPCGSetPrecond_flt( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LOBPCGSetPrecond_dbl( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LOBPCGSetPrecond_long_dbl( solver, precond, precond_setup, precond_solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LOBPCGSetPrecondUsageMode_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int mode )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LOBPCGSetPrecondUsageMode_flt( solver, mode );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LOBPCGSetPrecondUsageMode_dbl( solver, mode );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LOBPCGSetPrecondUsageMode_long_dbl( solver, mode );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LOBPCGSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LOBPCGSetPrintLevel_flt( solver, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LOBPCGSetPrintLevel_dbl( solver, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LOBPCGSetPrintLevel_long_dbl( solver, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LOBPCGSetRTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LOBPCGSetRTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LOBPCGSetRTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LOBPCGSetRTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LOBPCGSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LOBPCGSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LOBPCGSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LOBPCGSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LOBPCGSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Matrix A, HYPRE_Vector b, HYPRE_Vector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LOBPCGSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LOBPCGSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LOBPCGSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LOBPCGSetupB_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Matrix B, HYPRE_Vector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LOBPCGSetupB_flt( solver, B, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LOBPCGSetupB_dbl( solver, B, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LOBPCGSetupB_long_dbl( solver, B, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LOBPCGSetupT_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Matrix T, HYPRE_Vector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LOBPCGSetupT_flt( solver, T, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LOBPCGSetupT_dbl( solver, T, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LOBPCGSetupT_long_dbl( solver, T, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LOBPCGSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, mv_MultiVectorPtr y, mv_MultiVectorPtr x, void *lambda )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_LOBPCGSolve_flt( solver, y, x, lambda );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_LOBPCGSolve_dbl( solver, y, x, lambda );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_LOBPCGSolve_long_dbl( solver, y, x, lambda );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}



#endif

