"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ptr16MathConstantsNullable = exports.MathConstants = void 0;
const bin_composite_types_1 = require("@ot-builder/bin-composite-types");
const bin_util_1 = require("@ot-builder/bin-util");
const ot_layout_1 = require("@ot-builder/ot-layout");
const variance_1 = require("@ot-builder/variance");
const math_value_record_1 = require("../shared/math-value-record");
exports.MathConstants = {
    ...(0, bin_util_1.Read)(bp => {
        const x = new ot_layout_1.Math.Constants();
        x.scriptPercentScaleDown = bp.int16();
        x.scriptScriptPercentScaleDown = bp.int16();
        x.delimitedSubFormulaMinHeight = bp.uint16();
        x.displayOperatorMinHeight = bp.uint16();
        x.mathLeading = bp.next(math_value_record_1.MathValueRecord);
        x.axisHeight = bp.next(math_value_record_1.MathValueRecord);
        x.accentBaseHeight = bp.next(math_value_record_1.MathValueRecord);
        x.flattenedAccentBaseHeight = bp.next(math_value_record_1.MathValueRecord);
        x.subscriptShiftDown = bp.next(math_value_record_1.MathValueRecord);
        x.subscriptTopMax = bp.next(math_value_record_1.MathValueRecord);
        x.subscriptBaselineDropMin = bp.next(math_value_record_1.MathValueRecord);
        x.superscriptShiftUp = bp.next(math_value_record_1.MathValueRecord);
        x.superscriptShiftUpCramped = bp.next(math_value_record_1.MathValueRecord);
        x.superscriptBottomMin = bp.next(math_value_record_1.MathValueRecord);
        x.superscriptBaselineDropMax = bp.next(math_value_record_1.MathValueRecord);
        x.subSuperscriptGapMin = bp.next(math_value_record_1.MathValueRecord);
        x.superscriptBottomMaxWithSubscript = bp.next(math_value_record_1.MathValueRecord);
        x.spaceAfterScript = bp.next(math_value_record_1.MathValueRecord);
        x.upperLimitGapMin = bp.next(math_value_record_1.MathValueRecord);
        x.upperLimitBaselineRiseMin = bp.next(math_value_record_1.MathValueRecord);
        x.lowerLimitGapMin = bp.next(math_value_record_1.MathValueRecord);
        x.lowerLimitBaselineDropMin = bp.next(math_value_record_1.MathValueRecord);
        x.stackTopShiftUp = bp.next(math_value_record_1.MathValueRecord);
        x.stackTopDisplayStyleShiftUp = bp.next(math_value_record_1.MathValueRecord);
        x.stackBottomShiftDown = bp.next(math_value_record_1.MathValueRecord);
        x.stackBottomDisplayStyleShiftDown = bp.next(math_value_record_1.MathValueRecord);
        x.stackGapMin = bp.next(math_value_record_1.MathValueRecord);
        x.stackDisplayStyleGapMin = bp.next(math_value_record_1.MathValueRecord);
        x.stretchStackTopShiftUp = bp.next(math_value_record_1.MathValueRecord);
        x.stretchStackBottomShiftDown = bp.next(math_value_record_1.MathValueRecord);
        x.stretchStackGapAboveMin = bp.next(math_value_record_1.MathValueRecord);
        x.stretchStackGapBelowMin = bp.next(math_value_record_1.MathValueRecord);
        x.fractionNumeratorShiftUp = bp.next(math_value_record_1.MathValueRecord);
        x.fractionNumeratorDisplayStyleShiftUp = bp.next(math_value_record_1.MathValueRecord);
        x.fractionDenominatorShiftDown = bp.next(math_value_record_1.MathValueRecord);
        x.fractionDenominatorDisplayStyleShiftDown = bp.next(math_value_record_1.MathValueRecord);
        x.fractionNumeratorGapMin = bp.next(math_value_record_1.MathValueRecord);
        x.fractionNumDisplayStyleGapMin = bp.next(math_value_record_1.MathValueRecord);
        x.fractionRuleThickness = bp.next(math_value_record_1.MathValueRecord);
        x.fractionDenominatorGapMin = bp.next(math_value_record_1.MathValueRecord);
        x.fractionDenomDisplayStyleGapMin = bp.next(math_value_record_1.MathValueRecord);
        x.skewedFractionHorizontalGap = bp.next(math_value_record_1.MathValueRecord);
        x.skewedFractionVerticalGap = bp.next(math_value_record_1.MathValueRecord);
        x.overbarVerticalGap = bp.next(math_value_record_1.MathValueRecord);
        x.overbarRuleThickness = bp.next(math_value_record_1.MathValueRecord);
        x.overbarExtraAscender = bp.next(math_value_record_1.MathValueRecord);
        x.underbarVerticalGap = bp.next(math_value_record_1.MathValueRecord);
        x.underbarRuleThickness = bp.next(math_value_record_1.MathValueRecord);
        x.underbarExtraDescender = bp.next(math_value_record_1.MathValueRecord);
        x.radicalVerticalGap = bp.next(math_value_record_1.MathValueRecord);
        x.radicalDisplayStyleVerticalGap = bp.next(math_value_record_1.MathValueRecord);
        x.radicalRuleThickness = bp.next(math_value_record_1.MathValueRecord);
        x.radicalExtraAscender = bp.next(math_value_record_1.MathValueRecord);
        x.radicalKernBeforeDegree = bp.next(math_value_record_1.MathValueRecord);
        x.radicalKernAfterDegree = bp.next(math_value_record_1.MathValueRecord);
        x.radicalDegreeBottomRaisePercent = bp.int16();
        return x;
    }),
    ...(0, bin_util_1.Write)((fr, x) => {
        fr.int16(x.scriptPercentScaleDown);
        fr.int16(x.scriptScriptPercentScaleDown);
        fr.uint16(variance_1.OtVar.Ops.originOf(x.delimitedSubFormulaMinHeight));
        fr.uint16(variance_1.OtVar.Ops.originOf(x.displayOperatorMinHeight));
        fr.push(math_value_record_1.MathValueRecord, x.mathLeading);
        fr.push(math_value_record_1.MathValueRecord, x.axisHeight);
        fr.push(math_value_record_1.MathValueRecord, x.accentBaseHeight);
        fr.push(math_value_record_1.MathValueRecord, x.flattenedAccentBaseHeight);
        fr.push(math_value_record_1.MathValueRecord, x.subscriptShiftDown);
        fr.push(math_value_record_1.MathValueRecord, x.subscriptTopMax);
        fr.push(math_value_record_1.MathValueRecord, x.subscriptBaselineDropMin);
        fr.push(math_value_record_1.MathValueRecord, x.superscriptShiftUp);
        fr.push(math_value_record_1.MathValueRecord, x.superscriptShiftUpCramped);
        fr.push(math_value_record_1.MathValueRecord, x.superscriptBottomMin);
        fr.push(math_value_record_1.MathValueRecord, x.superscriptBaselineDropMax);
        fr.push(math_value_record_1.MathValueRecord, x.subSuperscriptGapMin);
        fr.push(math_value_record_1.MathValueRecord, x.superscriptBottomMaxWithSubscript);
        fr.push(math_value_record_1.MathValueRecord, x.spaceAfterScript);
        fr.push(math_value_record_1.MathValueRecord, x.upperLimitGapMin);
        fr.push(math_value_record_1.MathValueRecord, x.upperLimitBaselineRiseMin);
        fr.push(math_value_record_1.MathValueRecord, x.lowerLimitGapMin);
        fr.push(math_value_record_1.MathValueRecord, x.lowerLimitBaselineDropMin);
        fr.push(math_value_record_1.MathValueRecord, x.stackTopShiftUp);
        fr.push(math_value_record_1.MathValueRecord, x.stackTopDisplayStyleShiftUp);
        fr.push(math_value_record_1.MathValueRecord, x.stackBottomShiftDown);
        fr.push(math_value_record_1.MathValueRecord, x.stackBottomDisplayStyleShiftDown);
        fr.push(math_value_record_1.MathValueRecord, x.stackGapMin);
        fr.push(math_value_record_1.MathValueRecord, x.stackDisplayStyleGapMin);
        fr.push(math_value_record_1.MathValueRecord, x.stretchStackTopShiftUp);
        fr.push(math_value_record_1.MathValueRecord, x.stretchStackBottomShiftDown);
        fr.push(math_value_record_1.MathValueRecord, x.stretchStackGapAboveMin);
        fr.push(math_value_record_1.MathValueRecord, x.stretchStackGapBelowMin);
        fr.push(math_value_record_1.MathValueRecord, x.fractionNumeratorShiftUp);
        fr.push(math_value_record_1.MathValueRecord, x.fractionNumeratorDisplayStyleShiftUp);
        fr.push(math_value_record_1.MathValueRecord, x.fractionDenominatorShiftDown);
        fr.push(math_value_record_1.MathValueRecord, x.fractionDenominatorDisplayStyleShiftDown);
        fr.push(math_value_record_1.MathValueRecord, x.fractionNumeratorGapMin);
        fr.push(math_value_record_1.MathValueRecord, x.fractionNumDisplayStyleGapMin);
        fr.push(math_value_record_1.MathValueRecord, x.fractionRuleThickness);
        fr.push(math_value_record_1.MathValueRecord, x.fractionDenominatorGapMin);
        fr.push(math_value_record_1.MathValueRecord, x.fractionDenomDisplayStyleGapMin);
        fr.push(math_value_record_1.MathValueRecord, x.skewedFractionHorizontalGap);
        fr.push(math_value_record_1.MathValueRecord, x.skewedFractionVerticalGap);
        fr.push(math_value_record_1.MathValueRecord, x.overbarVerticalGap);
        fr.push(math_value_record_1.MathValueRecord, x.overbarRuleThickness);
        fr.push(math_value_record_1.MathValueRecord, x.overbarExtraAscender);
        fr.push(math_value_record_1.MathValueRecord, x.underbarVerticalGap);
        fr.push(math_value_record_1.MathValueRecord, x.underbarRuleThickness);
        fr.push(math_value_record_1.MathValueRecord, x.underbarExtraDescender);
        fr.push(math_value_record_1.MathValueRecord, x.radicalVerticalGap);
        fr.push(math_value_record_1.MathValueRecord, x.radicalDisplayStyleVerticalGap);
        fr.push(math_value_record_1.MathValueRecord, x.radicalRuleThickness);
        fr.push(math_value_record_1.MathValueRecord, x.radicalExtraAscender);
        fr.push(math_value_record_1.MathValueRecord, x.radicalKernBeforeDegree);
        fr.push(math_value_record_1.MathValueRecord, x.radicalKernAfterDegree);
        fr.int16(x.radicalDegreeBottomRaisePercent);
    })
};
exports.Ptr16MathConstantsNullable = (0, bin_composite_types_1.NullablePtr16)(exports.MathConstants);
//# sourceMappingURL=constants.js.map