import { __rest } from "tslib";
import { jsx as _jsx } from "react/jsx-runtime";
import { createRef, forwardRef } from 'react';
import styles from '@patternfly/react-styles/css/components/Menu/menu.mjs';
import { css } from '@patternfly/react-styles';
import { MenuContext } from './MenuContext';
import cssHeight from '@patternfly/react-tokens/dist/esm/c_menu__content_Height';
import cssMaxHeight from '@patternfly/react-tokens/dist/esm/c_menu__content_MaxHeight';
export const MenuContent = forwardRef((props, ref) => {
    const { getHeight, children, menuHeight, maxMenuHeight } = props, rest = __rest(props, ["getHeight", "children", "menuHeight", "maxMenuHeight"]);
    const menuContentRef = createRef();
    const refCallback = (el, menuId, onGetMenuHeight) => {
        if (el) {
            let clientHeight = el.clientHeight;
            // if this menu is a submenu, we need to account for the root menu list's padding and root menu content's border.
            let rootMenuList = null;
            let parentEl = el.closest(`.${styles.menuList}`);
            while (parentEl !== null && parentEl.nodeType === 1) {
                if (parentEl.classList.contains(styles.menuList)) {
                    rootMenuList = parentEl;
                }
                parentEl = parentEl.parentElement;
            }
            if (rootMenuList) {
                const rootMenuListStyles = getComputedStyle(rootMenuList);
                const rootMenuListPaddingOffset = parseFloat(rootMenuListStyles.getPropertyValue('padding-top').replace(/px/g, '')) +
                    parseFloat(rootMenuListStyles.getPropertyValue('padding-bottom').replace(/px/g, '')) +
                    parseFloat(getComputedStyle(rootMenuList.parentElement).getPropertyValue('border-bottom-width').replace(/px/g, ''));
                clientHeight = clientHeight + rootMenuListPaddingOffset;
            }
            onGetMenuHeight && onGetMenuHeight(menuId, clientHeight);
            getHeight && getHeight(clientHeight.toString());
        }
        return ref || menuContentRef;
    };
    return (_jsx(MenuContext.Consumer, { children: ({ menuId, onGetMenuHeight }) => (_jsx("div", Object.assign({}, rest, { className: css(styles.menuContent, props.className), ref: (el) => {
                refCallback(el, menuId, onGetMenuHeight);
            }, style: Object.assign(Object.assign({}, (menuHeight && { [cssHeight.name]: menuHeight })), (maxMenuHeight && { [cssMaxHeight.name]: maxMenuHeight })), children: children }))) }));
});
MenuContent.displayName = 'MenuContent';
//# sourceMappingURL=MenuContent.js.map