/*
 * Copyright (C) 2010-2011 David Robillard <d@drobilla.net>
 * Copyright (C) 2010-2013 Paul Davis <paul@linuxaudiosystems.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#pragma once

#include "pbd/cartesian.h"
#include "pbd/signals.h"

#include "ardour/libardour_visibility.h"

namespace ARDOUR {

class LIBARDOUR_API Speaker {
public:
	Speaker (int, const PBD::AngularVector& position);
	Speaker (const Speaker &);
	Speaker& operator= (const Speaker &);

	void move (const PBD::AngularVector& new_position);

	const PBD::CartesianVector& coords() const { return _coords; }
	const PBD::AngularVector&   angles() const { return _angles; }

	int id;

	/** emitted when this speaker's position has changed */
	PBD::Signal<void()> PositionChanged;

private:
	PBD::CartesianVector _coords;
	PBD::AngularVector   _angles;
};

} /* namespace */

