#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Flame in the Flood
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251013.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='the-flame-in-the-flood'
GAME_NAME='The Flame in the Flood'

ARCHIVE_BASE_1_NAME='setup_the_flame_in_the_flood_1.3.003_(31351).exe'
ARCHIVE_BASE_1_MD5='951cd129f7867c77b4a873d1ff88e038'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_PART1_NAME='setup_the_flame_in_the_flood_1.3.003_(31351)-1.bin'
ARCHIVE_BASE_1_PART1_MD5='60b72b81b7fd5a7af2ed65f9fa510ce6'
ARCHIVE_BASE_1_SIZE='2802565'
ARCHIVE_BASE_1_VERSION='1.3.003-gog31351'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/the_flame_in_the_flood'

ARCHIVE_BASE_0_NAME='setup_the_flame_in_the_flood_1.3.003_(31352).exe'
ARCHIVE_BASE_0_MD5='c58e4985cb0a93a27f6bcd542a313ff1'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='2900000'
ARCHIVE_BASE_0_VERSION='1.3.003-gog31352'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/the_flame_in_the_flood'

UNREALENGINE4_NAME='rivergame'

CONTENT_PATH_DEFAULT='.'

APP_MAIN_EXE='rivergame.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
